% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_research.r
\name{tt_user_follower_api}
\alias{tt_user_follower_api}
\alias{tt_user_following_api}
\title{Get followers and following of users from the research API}
\usage{
tt_user_follower_api(
  username,
  max_pages = 1,
  cache = TRUE,
  verbose = interactive(),
  token = NULL
)

tt_user_following_api(
  username,
  max_pages = 1,
  cache = TRUE,
  verbose = interactive(),
  token = NULL
)
}
\arguments{
\item{username}{name(s) of the user(s) to be queried}

\item{max_pages}{results are returned in batches/pages with 100 videos. How
many should be requested before the function stops?}

\item{cache}{should progress be saved in the current session? It can then be
retrieved with \code{last_query()} if an error occurs. But the function
will use extra memory.}

\item{verbose}{should the function print status updates to the screen?}

\item{token}{The authentication token (usually supplied automatically after
running \link{auth_research} once).}
}
\value{
A data.frame containing follower of following account information.
}
\description{
\ifelse{html}{\figure{api-research.svg}{options: alt='[Works on:
  Research API]'}}{\strong{[Works on: Research API]}}
}
\examples{
\dontrun{
tt_user_follower_api("jbgruber")
# OR
tt_user_following_api("https://www.tiktok.com/@tiktok")
# OR
tt_get_follower("https://www.tiktok.com/@tiktok")
}
}
