% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata_summary.R
\name{summary.trackeRdata}
\alias{summary.trackeRdata}
\title{Summary of training sessions.}
\usage{
\method{summary}{trackeRdata}(object, session = NULL,
  movingThreshold = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{\link{trackeRdata}}.}

\item{session}{A numeric vector of the sessions to be summarised, defaults to all sessions.}

\item{movingThreshold}{The threshold above which speed an athlete is considered moving (given in the unit of the speed measurements in \code{object}. If \code{NULL}, the default, the threshold corresponds to a slow walking speed (1 m/s, converted to another speed unit, if necessary). For reference, the preferred walking speed for humans is around 1.4 m/s (Bohannon, 1997).}

\item{...}{Currently not used.}
}
\value{
An object of class \code{trackeRdataSummary}.
}
\description{
Summary of training sessions.
}
\examples{
data(runs, package = "trackeR")
runSummary <- summary(runs, session = 1:2)
## print summary
runSummary
print(runSummary, digits = 3)
## change units
changeUnits(runSummary, variable = "speed", unit = "km_per_h")
## plot summary
runSummaryFull <- summary(runs)
plot(runSummaryFull)
plot(runSummaryFull, group = c("total", "moving"),
    what = c("avgSpeed", "distance", "duration", "avgHeartRate"))
}
\references{
Bohannon RW (1997). "Comfortable and Maximum Walking Speed of Adults Aged 20--79 Years: Reference Values and Determinants." Age and Ageing, 26(1), 15--19. doi: 10.1093/ageing/26.1.15.
}
\seealso{
\code{\link{plot.trackeRdataSummary}}
}

