% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{fragments_trace}
\alias{fragments_trace}
\title{fragments_trace object}
\description{
An R6 Class representing a fragments_trace object.
}
\details{
The idea behind this class is to store data for processing of the continuous trace-level information from an fsa file towards peak level data.

It also contains methods for plotting the ladder and traces
}
\section{Super class}{
\code{\link[trace:fragments]{trace::fragments}} -> \code{fragments_trace}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{unique_id}}{unique id of the sample usually the file name}

\item{\code{fsa}}{The whole fsa file, output from seqinr::read.abif()}

\item{\code{raw_ladder}}{The raw data from the ladder channel}

\item{\code{raw_data}}{The raw data from the sample channel}

\item{\code{scan}}{The scan number}

\item{\code{off_scale_scans}}{vector indicating which scales were too big and off scale. Note can be in any channel}

\item{\code{ladder_df}}{A dataframe of the identified ladder from \code{find_ladders()}. Scan is the scan number of peak and size is the associated bp size.}

\item{\code{trace_bp_df}}{A dataframe of bp size for every scan from \code{find_ladders()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-fragments_trace-new}{\code{fragments_trace$new()}}
\item \href{#method-fragments_trace-plot_ladder}{\code{fragments_trace$plot_ladder()}}
\item \href{#method-fragments_trace-plot_data_channels}{\code{fragments_trace$plot_data_channels()}}
\item \href{#method-fragments_trace-clone}{\code{fragments_trace$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="trace" data-topic="fragments" data-id="plot_trace"><a href='../../trace/html/fragments.html#method-fragments-plot_trace'><code>trace::fragments$plot_trace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="trace" data-topic="fragments" data-id="print"><a href='../../trace/html/fragments.html#method-fragments-print'><code>trace::fragments$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fragments_trace-new"></a>}}
\if{latex}{\out{\hypertarget{method-fragments_trace-new}{}}}
\subsection{Method \code{new()}}{
Create a new fragments_trace.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fragments_trace$new(unique_id, fsa_file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{unique_id}}{usually the file name}

\item{\code{fsa_file}}{output from seqinr::read.abif()}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{fragments_trace} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fragments_trace-plot_ladder"></a>}}
\if{latex}{\out{\hypertarget{method-fragments_trace-plot_ladder}{}}}
\subsection{Method \code{plot_ladder()}}{
plot the ladder data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fragments_trace$plot_ladder(xlim = NULL, ylim = NULL, plot_title = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xlim}}{numeric vector length two specifying the x axis limits}

\item{\code{ylim}}{numeric vector length two specifying the y axis limits}

\item{\code{plot_title}}{A character string for setting the plot title. Defaults to the unique id of the object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A base R plot
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fragments_trace-plot_data_channels"></a>}}
\if{latex}{\out{\hypertarget{method-fragments_trace-plot_data_channels}{}}}
\subsection{Method \code{plot_data_channels()}}{
plot the raw data channels in the fsa file. It identifies every channel that has "DATA" in its name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fragments_trace$plot_data_channels()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A base R plot
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fragments_trace-clone"></a>}}
\if{latex}{\out{\hypertarget{method-fragments_trace-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fragments_trace$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
