% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/methods-TxpModelList.R
\docType{class}
\name{TxpModelList-class}
\alias{TxpModelList-class}
\alias{TxpModelList}
\alias{duplicated,TxpModelList-method}
\alias{as.TxpModelList}
\title{List of TxpModel objects}
\usage{
TxpModelList(...)

\S4method{duplicated}{TxpModelList}(x)

as.TxpModelList(x)
}
\arguments{
\item{...}{\link{TxpModel} object to create \code{TxpModelList} object}

\item{x}{\code{TxpModelList} object}
}
\description{
Extension of \link[S4Vectors:SimpleList-class]{S4Vectors::SimpleList} that holds only \link{TxpModel}
objects.
}
\section{Functions}{
\itemize{
\item \code{duplicated,TxpModelList-method}: Returns logical vector of \code{length(x)}, where
\code{TRUE} indicates a duplicate model in the list; see \link[base:duplicated]{base::duplicated}

\item \code{as.TxpModelList}: Coerce list or \link{TxpModel} objects to
TxpModelList
}}

\examples{
## Create some TxpModel objects; see ?TxpModel for more details
s1 <- list(S1 = TxpSlice("inpt1"), S2 = TxpSlice("inpt2"))
tf <- list(NULL, sqrt = function(x) sqrt(x))
m1 <- TxpModel(txpSlices = s1, txpWeights = 2:1, txpTransFuncs = tf)
m2 <- m1
txpSlices(m2) <- list(S3 = TxpSlice("inpt3"), S4 = TxpSlice("inpt4"))
m3 <- merge(m1, m2)

## Build a TxpModelList object
TxpModelList(m1 = m1, m2 = m2, m3 = m3)

## Note: names are printed as '' when all are NULL
TxpModelList(m1, m2, m3)
names(TxpModelList(m1, m2, m3))

## Test for duplicates
duplicated(TxpModelList(m1 = m1, m2 = m2, m3 = m3))
duplicated(TxpModelList(m1 = m1, m2 = m1, m3 = m3))

## Coerce lists/TxpModel objects to TxpModelList
as(list(m1 = m1, m2 = m2, m3 = m3), "TxpModelList")
as.TxpModelList(list(m1 = m1, m2 = m2, m3 = m3))

as(m1, "TxpModelList")
as.TxpModelList(m1)
}
