% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodesic-path.r
\name{new_geodesic_path}
\alias{new_geodesic_path}
\title{Generate a geodesic path between bases supplied by generator}
\usage{
new_geodesic_path(name, generator, frozen = NULL, ...)
}
\arguments{
\item{name}{name to give tour path}

\item{generator}{basis generator function}

\item{frozen}{matrix giving frozen variables, as described in
\code{\link{freeze}}}
}
\description{
A tour path is a function that when called with the current projection
and data set, generates sequence of \code{\link{geodesic_path}}s.  The
path can either span the whole space of orthonormal matrices, the default
or be restricted to a subspace with the frozen argument.  More details
are given in the documentation for \code{\link{freeze}}.
}
\details{
Subsequent frames are guaranteed to be at least 0.001 radians away from
the current frame.  If after 10 tries the generator does not give a new
basis at least this far away then we give up.

If a suitable new basis can not be found, the path function returns NULL
indicating that the tour should stop.
}
\keyword{internal}
