% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tour-guided.r
\name{guided_tour}
\alias{guided_tour}
\title{A guided tour path.}
\usage{
guided_tour(
  index_f,
  d = 2,
  alpha = 0.5,
  cooling = 0.99,
  max.tries = 25,
  max.i = Inf,
  search_f = search_geodesic,
  n_sample = 100,
  ...
)
}
\arguments{
\item{index_f}{the index function to optimise.}

\item{d}{target dimensionality}

\item{alpha}{the initial size of the search window, in radians}

\item{cooling}{the amount the size of the search window should be adjusted
by after each step}

\item{max.tries}{the maximum number of unsuccessful attempts to find
a better projection before giving up}

\item{max.i}{the maximum index value, stop search if a larger value is found}

\item{search_f}{the search strategy to use: \code{\link{search_geodesic}}, \code{\link{search_better}},
\code{\link{search_better_random}}, \code{\link{search_polish}}. Default is \code{\link{search_geodesic}}.}

\item{n_sample}{number of samples to generate if \code{search_f} is \code{\link{search_polish}}}

\item{...}{arguments sent to the search_f}
}
\description{
Instead of choosing new projections at random like the grand tour, the
guided tour always tries to find a projection that is more interesting
than the current projection.
}
\details{
Currently the index functions only work in 2d.

Usually, you will not call this function directly, but will pass it to
a method that works with tour paths like \code{\link{animate}},
\code{\link{save_history}} or \code{\link{render}}.
}
\examples{
animate_xy(flea[, 1:6], guided_tour(holes()), sphere = TRUE)
\donttest{
animate_xy(flea[, 1:6], guided_tour(holes(), search_f = search_better_random), sphere = TRUE)
animate_dist(flea[, 1:6], guided_tour(holes(), 1), sphere = TRUE)
animate_xy(flea[, 1:6], guided_tour(lda_pp(flea$species)), sphere = TRUE, col = flea$species)

# save_history is particularly useful in conjunction with the
# guided tour as it allows us to look at the tour path in many different
# ways
f <- flea[, 1:3]
tries <- replicate(5, save_history(f, guided_tour(holes())), simplify = FALSE)
}
}
\seealso{
\code{\link{cmass}}, \code{\link{holes}} and \code{\link{lda_pp}}
  for examples of index functions.  The function should take a numeric
  matrix and return a single number, preferably between 0 and 1.
\code{\link{search_geodesic}}, \code{\link{search_better}},
  \code{\link{search_better_random}} for different search strategies
}
