% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_census_and_acs.R
\name{search_geoheaders}
\alias{search_geoheaders}
\title{Search Geographic Headers}
\usage{
search_geoheaders(survey, years = NULL, keywords = NULL, view = TRUE)
}
\arguments{
\item{survey}{survey type, including "dec" (or "decennial"), "acs1" or "acs5".}

\item{years}{year or ending year of the survey, can be a single year such as
2010 or a vector like 2014:2016.}

\item{keywords}{keyword to search in code or description, in the form like
"abc def dsdfsa". Rows with all words are returned.}

\item{view}{display the search result with View if TRUE}
}
\value{
data.table matching the search criteria
}
\description{
Search in field reference or description of geographic header
records to find the reference of "geo_headers" argument in function \code{\link{read_decennial}},
\code{\link{read_acs1year}}, and \code{\link{read_acs5year}}.
}
\examples{
# Change view = TRUE (default) to View the returned data.
# search geoheader that contains keyword "india" in decennial 2010
aaa <- search_geoheaders("decennial", "india", view = FALSE)

# search for lattitude
bbb <- search_geoheaders("dec", 2010, "latitu", view = FALSE)


\dontrun{
  # browse all geoheaders in ACS i year in View()
  search_geoheaders("acs1")
}

}
