% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterTopics.R
\name{clusterTopics}
\alias{clusterTopics}
\title{Cluster Analysis}
\usage{
clusterTopics(
  ldaresult,
  file,
  tnames = NULL,
  method = "average",
  width = 30,
  height = 15,
  ...
)
}
\arguments{
\item{ldaresult}{The result of a function call \code{\link{LDAgen}} -
alternatively the corresponding matrix \code{result$topics}}

\item{file}{File for the dendogram pdf.}

\item{tnames}{Character vector as label for the topics.}

\item{method}{Method statement from \code{\link[stats]{hclust}}}

\item{width}{Grafical parameter for pdf output. See \code{\link[grDevices]{pdf}}}

\item{height}{Grafical parameter for pdf output. See \code{\link[grDevices]{pdf}}}

\item{...}{Additional parameter for \code{\link[graphics]{plot}}}
}
\value{
A dendogram as pdf and a list containing \item{dist}{A distance matrix}
\item{clust}{The result from \code{hclust}}
}
\description{
This function makes a cluster analysis using the Hellinger distance.
}
\details{
This function is useful to analyze
topic similarities and while evaluating the right number of topics of LDAs.
}
\examples{

texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
Teach a Man To Fish, and You Feed Him for a Lifetime",
B="So Long, and Thanks for All the Fish",
C="A very able manipulative mathematician, Fisher enjoys a real mastery
in evaluating complicated multiple integrals.")

corpus <- textmeta(meta=data.frame(id=c("A", "B", "C", "D"),
title=c("Fishing", "Don't panic!", "Sir Ronald", "Berlin"),
date=c("1885-01-02", "1979-03-04", "1951-05-06", "1967-06-02"),
additionalVariable=1:4, stringsAsFactors=FALSE), text=texts)

corpus <- cleanTexts(corpus)
wordlist <- makeWordlist(corpus$text)
ldaPrep <- LDAprep(text=corpus$text, vocab=wordlist$words)

\donttest{LDA <- LDAgen(documents=ldaPrep, K = 3L, vocab=wordlist$words, num.words=3)}
\donttest{clusterTopics(ldaresult=LDA)}

}
