% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-init.R
\name{nn_init_kaiming_normal_}
\alias{nn_init_kaiming_normal_}
\title{Kaiming normal initialization}
\usage{
nn_init_kaiming_normal_(
  tensor,
  a = 0,
  mode = "fan_in",
  nonlinearity = "leaky_relu"
)
}
\arguments{
\item{tensor}{an n-dimensional \code{torch.Tensor}}

\item{a}{the negative slope of the rectifier used after this layer (only used
with \code{'leaky_relu'})}

\item{mode}{either 'fan_in' (default) or 'fan_out'. Choosing 'fan_in' preserves
the magnitude of the variance of the weights in the forward pass. Choosing
'fan_out' preserves the magnitudes in the backwards pass.}

\item{nonlinearity}{the non-linear function. recommended to use only with 'relu'
or 'leaky_relu' (default).}
}
\description{
Fills the input \code{Tensor} with values according to the method
described in \verb{Delving deep into rectifiers: Surpassing human-level performance on ImageNet classification} - He, K. et al. (2015), using a
normal distribution.
}
\examples{
if (torch_is_installed()) {
w <- torch_empty(3, 5)
nn_init_kaiming_normal_(w, mode = "fan_in", nonlinearity = "leaky_relu")
}
}
