% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_diagonal}
\alias{torch_diagonal}
\title{Diagonal}
\arguments{
\item{input}{(Tensor) the input tensor. Must be at least 2-dimensional.}

\item{offset}{(int, optional) which diagonal to consider. Default: 0        (main diagonal).}

\item{dim1}{(int, optional) first dimension with respect to which to        take diagonal. Default: 0.}

\item{dim2}{(int, optional) second dimension with respect to which to        take diagonal. Default: 1.}
}
\description{
Diagonal
}
\section{diagonal(input, offset=0, dim1=0, dim2=1) -> Tensor }{


Returns a partial view of \code{input} with the its diagonal elements
with respect to \code{dim1} and \code{dim2} appended as a dimension
at the end of the shape.

The argument \code{offset} controls which diagonal to consider:
\itemize{
\item If \code{offset} = 0, it is the main diagonal.
\item If \code{offset} > 0, it is above the main diagonal.
\item If \code{offset} < 0, it is below the main diagonal.
}

Applying \code{torch_diag_embed} to the output of this function with
the same arguments yields a diagonal matrix with the diagonal entries
of the input. However, \code{torch_diag_embed} has different default
dimensions, so those need to be explicitly specified.
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(3, 3))
a
torch_diagonal(a, offset = 0)
torch_diagonal(a, offset = 1)
x = torch_randn(c(2, 5, 4, 2))
torch_diagonal(x, offset=-1, dim1=1, dim2=2)
}
}
