% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_distance_heatmap}
\alias{plot_distance_heatmap}
\title{Plot Distance Matrix Heatmap}
\usage{
plot_distance_heatmap(
  heatmap_data,
  output_file = NULL,
  aesthetic_config = new_aesthetic_config(),
  layout_config = new_layout_config()
)
}
\arguments{
\item{heatmap_data}{List output from prepare_heatmap_data()}

\item{output_file}{Character. Full path (including filename and extension) where the plot will be saved.
If NULL, the plot is not saved.}

\item{aesthetic_config}{Plot aesthetic configuration object}

\item{layout_config}{Plot layout configuration object}
}
\value{
A ggplot object containing:
\itemize{
\item Heatmap visualization of the distance matrix
\item Color gradient representing distance values
\item Title showing matrix completeness percentage
}
}
\description{
Creates heatmap visualization of distance matrix showing patterns and
structure in the measurements.
}
\examples{
# Create sample heatmap data
dist_mat <- matrix(rnorm(100), 10, 10)
hmap_data <- prepare_heatmap_data(dist_mat)

# Create and display the plot object
plot_distance_heatmap(hmap_data)

}
