% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{new_layout_config}
\alias{new_layout_config}
\title{Plot Layout Configuration Class}
\usage{
new_layout_config(
  width = 8,
  height = 8,
  dpi = 300,
  aspect_ratio = 1,
  show_grid = TRUE,
  grid_type = "major",
  grid_color = "grey80",
  grid_linetype = "dashed",
  show_axis = TRUE,
  axis_lines = TRUE,
  plot_margin = margin(1, 1, 1, 1, "cm"),
  coord_type = "fixed",
  background_color = "white",
  panel_background_color = "white",
  panel_border = TRUE,
  panel_border_color = "black",
  save_plot = FALSE,
  save_format = "png",
  reverse_x = 1,
  reverse_y = 1,
  x_limits = NULL,
  y_limits = NULL,
  arrow_plot_threshold = 0.1
)
}
\arguments{
\item{width}{Plot width in inches}

\item{height}{Plot height in inches}

\item{dpi}{Plot resolution}

\item{aspect_ratio}{Plot aspect ratio}

\item{show_grid}{Show plot grid}

\item{grid_type}{Grid type ("none", "major", "minor", "both")}

\item{grid_color}{Grid color}

\item{grid_linetype}{Grid line type}

\item{show_axis}{Show axes}

\item{axis_lines}{Show axis lines}

\item{plot_margin}{Plot margins in cm}

\item{coord_type}{Coordinate type ("fixed", "equal", "flip", "polar")}

\item{background_color}{Plot background color}

\item{panel_background_color}{Panel background color}

\item{panel_border}{Show panel border}

\item{panel_border_color}{Panel border color}

\item{save_plot}{Logical. Whether to save the plot to a file.}

\item{save_format}{Plot save format ("png", "pdf", "svg", "eps")}

\item{reverse_x}{Numeric multiplier for x-axis direction (1 or -1)}

\item{reverse_y}{Numeric multiplier for y-axis direction (1 or -1)}

\item{x_limits}{Numeric vector of length 2 specifying c(min, max) for x-axis. If NULL, limits are set automatically.}

\item{y_limits}{Numeric vector of length 2 specifying c(min, max) for y-axis. If NULL, limits are set automatically.}

\item{arrow_plot_threshold}{Threshold for velocity arrows to be drawn in the same antigenic distance unit (default: 0.10)}
}
\value{
An S3 object of class \code{layout_config}, which is a list containing
the specified configuration parameters for plot layout.
}
\description{
S3 class for configuring plot layout including dimensions, margins,
grids and coordinate systems.
}
