% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiments.R
\name{create_cv_folds}
\alias{create_cv_folds}
\title{Create Cross-validation Folds for Distance Matrix}
\usage{
create_cv_folds(
  truth_matrix,
  no_noise_truth = NULL,
  n_folds = 10,
  random_seed = NULL
)
}
\arguments{
\item{truth_matrix}{Matrix of true distances}

\item{no_noise_truth}{Optional matrix of noise-free distances. If provided, used as truth.}

\item{n_folds}{Integer number of folds to create}

\item{random_seed}{Integer random seed for reproducibility}
}
\value{
A list of length \code{n_folds}. Each element is a list containing two matrices:
\item{truth}{The truth matrix for that fold.}
\item{train}{The training matrix with some values replaced by \code{NA} for validation.}
}
\description{
Creates k-fold cross-validation splits of a distance matrix while maintaining
symmetry. Each fold has a training matrix with some values masked for validation.
}
\examples{
# Create a sample distance matrix
dist_matrix <- matrix(runif(100), 10, 10)
diag(dist_matrix) <- 0
# Create 5-fold CV splits
folds <- create_cv_folds(dist_matrix, n_folds = 5, random_seed = 123)
}
