% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag_tokens.r
\name{colorscale_tokens}
\alias{colorscale_tokens}
\title{Color tokens using colorRamp}
\usage{
colorscale_tokens(
  tokens,
  value,
  alpha = 0.4,
  col_range = c("red", "blue"),
  span_adjacent = F
)
}
\arguments{
\item{tokens}{A character vector of tokens}

\item{value}{A numeric vector with values between -1 and 1. Determines the color mixture of the scale colors
specified in col_range}

\item{alpha}{Optionally, the alpha (transparency) can be specified, with 0 being fully transparent and 1 being
fully colored. This can be a vector to specify a different alpha for each value.}

\item{col_range}{The colors used in the scale ramp.}

\item{span_adjacent}{If TRUE, include adjacent tokens with identical attributes within the same tag}
}
\value{
a character vector of color-tagged tokens
}
\description{
This is a convenience wrapper for tag_tokens() that can be used if tokens only need to be colored.
}
\examples{
colorscale_tokens(c('token_1','token_2','token_3'),
                 value = c(-1,0,1))
}
