% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{calendar-shiny}
\alias{calendar-shiny}
\alias{calendarOutput}
\alias{renderCalendar}
\title{Shiny bindings for \code{\link[=calendar]{calendar()}}}
\usage{
calendarOutput(outputId, width = "100\%", height = "600px")

renderCalendar(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{Output variable to read from.}

\item{width, height}{Must be a valid CSS unit (like \verb{100\%},
\verb{400px}, \code{auto}) or a number, which will be coerced to a
string and have \code{px} appended.}

\item{expr}{An expression that generates a calendar}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
Output element that can be included in UI. Render function to create output in server.
}
\description{
Output and render functions for using \code{\link[=calendar]{calendar()}} within Shiny
applications and interactive Rmd documents.
}
\section{Special inputs}{
The following \code{input} values will be accessible in the server:
\itemize{
\item \strong{input$outputId_add} : contain data about schedule added via the creation popup. Javascript event: \code{beforeCreateSchedule}.
\item \strong{input$outputId_schedules} : contain data about last schedule added. Javascript event: \code{afterRenderSchedule}.
\item \strong{input$outputId_click} : contain data about schedule user click on. Javascript event: \code{clickSchedule}.
\item \strong{input$outputId_delete} : contain data about schedule deleted by user via creation popup. Javascript event: \code{beforeDeleteSchedule}.
\item \strong{input$outputId_update} : contain data about schedule updated by user via creation popup. Javascript event: \code{beforeUpdateSchedule}.
\item \strong{input$outputId_dates} : start and end date represented in the calendar.
}

To use them you need to replace \code{outputId} by the id you've used to create the calendar.
If you use one of the above javascript event in \code{\link[=cal_events]{cal_events()}}, the input won't be accessible.
}

\examples{
library(shiny)
library(toastui)

ui <- fluidPage(
  tags$h2("calendar shiny example"),
  fluidRow(
    column(
      width = 8,
      calendarOutput("my_calendar")
    ),
    column(
      width = 4,
      tags$b("Dates:"),
      verbatimTextOutput("dates"),
      tags$b("Clicked schedule:"),
      verbatimTextOutput("click")
    )
  )
)

server <- function(input, output, session) {

  output$my_calendar <- renderCalendar({
    calendar(cal_demo_data(), navigation = TRUE) \%>\%
      cal_props(
        list(
          id = 1,
          name = "PERSO",
          color = "white",
          bgColor = "firebrick",
          borderColor = "firebrick"
        ),
        list(
          id = 2,
          name = "WORK",
          color = "white",
          bgColor = "forestgreen",
          borderColor = "forestgreen"
        )
      )
  })

  output$dates <- renderPrint({
    input$my_calendar_dates
  })

  output$click <- renderPrint({
    input$my_calendar_click
  })

}

if (interactive())
  shinyApp(ui, server)
}
