% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmF.R
\name{tm}
\alias{tm}
\title{Fitting Trimmed Mean Linear Models:}
\usage{
tm(
  formula,
  GR,
  trF = NULL,
  side = c("LOW", "HIGH"),
  n_perm = 1000,
  adj_est = FALSE,
  data
)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}}, specifying the model, of the form
\code{outcome ~ terms}, where \code{terms} must include the binary treatment variable, with additional
variables optional.}

\item{GR}{a string denoting the name of the binary treatment variable. This function assumes the
lowest value to be the comparator/reference group}

\item{trF}{a number between 0 and 1, specifying the trimming fraction: the proportion of the data that is trimmed away
for each treatment group. \code{trF} should be equal to or greater than the largest observed
dropout proportion. If left unspecified, a default trimming fraction of 0.5 is assumed.}

\item{side}{specifies if higher value trimming (\code{"HIGH"}) or lower value trimming (\code{"LOW"}) should be performed.}

\item{n_perm}{the number of permutations performed to obtain the p-value and 95\% confidence intervals
for the estimates. Default is 1000.}

\item{adj_est}{logical. If \code{TRUE} the adjusted trimmed means estimate is computed. The default is \code{FALSE}.}

\item{data}{a data frame containing the variables in the model. \code{data} should contain at least the following:
a numeric outcome variable and a binary treatment variable (numeric, character or factor).}
}
\value{
\code{tm} returns an object of class \code{tm}.
The function \code{summary} is used to obtain a summary of the results. The generic accessor function
\code{coefficients} extracts the regression coefficients with corresponding p-values and 95\% confidence intervals.

An object of class "\code{tm}" is a list containing the following components:
\item{call}{the matched call}
\item{n}{the number of observations per treatment group}
\item{dropout}{the proportion of dropout per treatment group}
\item{trimfrac}{the proportion of data that was trimmed away per treatment group}
\item{trimside}{specifies if lower or higher value trimming was performed}
\item{n_after_trimming}{the number of observations per treatment group after trimming}
\item{coefficients}{an array of coefficients with corresponding p-values and 95\% confidence intervals}
\item{Analysis_details}{reiterates trimming fraction and side, and, for adjest=TRUE specifies if the adjustment was performed on the comparator or treatment group.}
\item{SD_outcome}{an array of the standard deviation per treatment group, for the observed outcomes and for the trimmed outcomes}
}
\description{
\code{tm} performs a trimmed means analysis for data with a continuous outcome/response and a binary
treatment/exposure variable. Outcomes are sorted and trimmed per treatment group, and a linear
regression is fitted using \code{\link{lm}}.
}
\section{Details}{
 The trimmed means estimate is subject to two assumptions: the strong MNAR assumption requires
that all dropouts (unobserved outcome values) are located in the fraction of the distribution
that is trimmed away; the location shift assumption requires the group variances of the full sample
to be equal. The adjusted trimmed means estimator relaxes the latter, but assumes normally
distributed outcomes. The adjustment is performed on the group with the smallest dropout proportion.

The p-value and 95\% confidence intervals for the trimmed means estimate and the adjusted trimmed means
estimate are obtained in a permutation approach.
}

\examples{
set.seed(123456)
test_dat <- as.data.frame(cbind(c(rep(0, 500), rep(1, 500)),
                          c(sort(rnorm(500, 0, 1)), sort(rnorm(500, 1, 1.5))),
                          rbinom(1000, 2, 0.4), rnorm(1000, 0, 1)))
colnames(test_dat) <- c("TR", "Y", "U", "U2")
test_dat$Y[1:200] <- NA
# Note that we usually recommend setting n_perm to a larger value, e.g., 1000
tm_obj <- tm(formula= Y ~ TR + U + U2,
             GR = "TR", trF = 0.5, side = "LOW",
             n_perm = 100, adj_est = TRUE, data = test_dat)
print(tm_obj)
summary(tm_obj)
}
