% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_misc_elements.R
\name{tm_grid}
\alias{tm_grid}
\alias{tm_graticules}
\title{Coordinate grid / graticule lines}
\usage{
tm_grid(x = NA, y = NA, n.x = NA, n.y = NA, projection = NA,
  col = NA, lwd = 1, alpha = NA, labels.show = TRUE,
  labels.size = 0.6, labels.col = NA, labels.rot = c(0, 0),
  labels.format = list(big.mark = ","), labels.cardinal = FALSE,
  labels.margin.x = 0, labels.margin.y = 0, labels.space.x = NA,
  labels.space.y = NA, labels.inside.frame = FALSE,
  ticks = labels.show && !labels.inside.frame, lines = TRUE,
  ndiscr = 100, zindex = NA)

tm_graticules(x = NA, y = NA, n.x = NA, n.y = NA,
  projection = "longlat", labels.format = list(suffix =
  intToUtf8(176)), labels.cardinal = TRUE, ...)
}
\arguments{
\item{x}{x coordinates for vertical grid lines. If \code{NA}, it is specified with a pretty scale and \code{n.x}.}

\item{y}{y coordinates for horizontal grid lines. If \code{NA}, it is specified with a pretty scale and \code{n.y}.}

\item{n.x}{preferred number of grid lines for the x axis. For the labels, a \code{\link{pretty}} sequence is used, so the number of actual labels may be different than \code{n.x}.}

\item{n.y}{preferred number of grid lines for the y axis. For the labels, a \code{\link{pretty}} sequence is used, so the number of actual labels may be different than \code{n.y}.}

\item{projection}{projection character. If specified, the grid lines are projected accordingly. See \code{\link[tmaptools:set_projection]{set_projection}} for projection details. Many world maps are projected, but still have latitude longitude (\code{"longlat"}) grid lines.}

\item{col}{color of the grid lines.}

\item{lwd}{line width of the grid lines}

\item{alpha}{alpha transparency of the grid lines. Number between 0 and 1. By default, the alpha transparency of \code{col} is taken.}

\item{labels.show}{show tick labels}

\item{labels.size}{font size of the tick labels}

\item{labels.col}{font color of the tick labels}

\item{labels.rot}{Rotation angles of the labels. Vector of two values: the first is the rotation angle (in degrees) of the tick labels on the x axis and the second is the rotation angle of the tick labels on the y axis. Only \code{0}, \code{90}, \code{180}, and \code{270} are valid values.}

\item{labels.format}{list of formatting options for the grid labels. Parameters are:
\describe{
\item{fun}{Function to specify the labels. It should take a numeric vector, and should return a character vector of the same size. By default it is not specified. If specified, the list items \code{scientific}, \code{format}, and \code{digits} (see below) are not used.}
\item{scientific}{Should the labels be formatted scientifically? If so, square brackets are used, and the \code{format} of the numbers is \code{"g"}. Otherwise, \code{format="f"}, and \code{text.separator}, \code{text.less.than}, and \code{text.or.more} are used. Also, the numbers are automatically  rounded to millions or billions if applicable.}
\item{format}{By default, \code{"f"}, i.e. the standard notation \code{xxx.xxx}, is used. If \code{scientific=TRUE} then \code{"g"}, which means that numbers are formatted scientifically, i.e. \code{n.dddE+nn} if needed to save space.}
\item{digits}{Number of digits after the decimal point if \code{format="f"}, and the number of significant digits otherwise.}
\item{...}{Other arguments passed on to \code{\link[base:formatC]{formatC}}}
}}

\item{labels.cardinal}{add the four cardinal directions (N, E, S, W) to the labels, instead of using negative coordiantes for west and south (so it assumes that the coordinates are positive in the north-east direction).}

\item{labels.margin.x}{margin between tick labels of x axis and the frame. Note that when \code{labels.inside.frame == FALSE} and \code{ticks == TRUE}, the ticks will be adjusted accordingly.}

\item{labels.margin.y}{margin between tick labels of y axis and the frame. Note that when \code{labels.inside.frame == FALSE} and \code{ticks == TRUE}, the ticks will be adjusted accordingly.}

\item{labels.space.x}{space that is used for the labels and ticks for the x-axis when \code{labels.inside.frame == FALSE}. By default, it is determined automatically using the widths and heights of the tick labels. The unit of this parameter is text line height.}

\item{labels.space.y}{space that is used for the labels and ticks for the y-axis when \code{labels.inside.frame == FALSE}. By default, it is determined automatically using the widths and heights of the tick labels. The unit of this parameter is text line height.}

\item{labels.inside.frame}{Show labels inside the frame? By default \code{FALSE}}

\item{ticks}{If \code{labels.inside.frame = FALSE}, should ticks can be drawn between the labels and the frame?}

\item{lines}{If \code{labels.inside.frame = FALSE}, should grid lines can be drawn?}

\item{ndiscr}{number of points to discretize a parallel or meridian (only applicable for curved grid lines)}

\item{zindex}{zindex of the pane in view mode. By default, it is set to the layer number plus 400. By default, the tmap layers will therefore be placed in the custom panes \code{"tmap401"}, \code{"tmap402"}, etc., except for the base tile layers, which are placed in the standard \code{"tile"}. This parameter determines both the name of the pane and the z-index, which determines the pane order from bottom to top. For instance, if \code{zindex} is set to 500, the pane will be named \code{"tmap500"}.}

\item{...}{arguments passed on to \code{tm_grid}}
}
\description{
Creates a \code{\link{tmap-element}} that draws coordinate grid lines. It serves as a layer that can be drawn anywhere between other layers. By default, \code{tm_grid} draws horizontal and vertical lines acording to the coordinate system of the (master) shape object. Latitude and longitude graticules are drawn with \code{tm_graticules}.
}
\examples{
current.mode <- tmap_mode("plot")

data(NLD_muni, World)

tmap_arrange(
	qtm(NLD_muni, borders = NULL) + tm_grid(),
	qtm(NLD_muni, borders = NULL) + tm_graticules()
)

qtm(World, shape.projection = "robin", style = "natural") +
	tm_graticules(ticks = FALSE) +
	tm_layout(frame=FALSE)

tmap_mode(current.mode)
}
