% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_misc_elements.R
\name{tm_logo}
\alias{tm_logo}
\title{Logo}
\usage{
tm_logo(file, height = 3, halign = "center", margin = 0.2,
  position = NA, just = NA)
}
\arguments{
\item{file}{either a filename or url of a png image. If multiple files/urls are provided with a character vector, the logos are placed near each other. To specify logos for small multiples use a list of character values/vectors. In order to stack logos vertically, multiple \code{tm_logo} elements can be stacked.}

\item{height}{height of the logo in number of text line heights. The width is scaled based the height and the aspect ratio of the logo. If multiple logos are specified by a vector or list, the heights can be specified accordingly.}

\item{halign}{if logos in one row have different heights, \code{halign} specifies the vertical alignment. Possible values are \code{"top"}, \code{"center"} and \code{"bottom"}.}

\item{margin}{margin around the logo in number of text line heights.}

\item{position}{position of the logo. Vector of two values, specifing the x and y coordinates. Either this vector contains "left", "LEFT", "center", "right", or "RIGHT" for the first value and "top", "TOP", "center", "bottom", or "BOTTOM" for the second value, or this vector contains two numeric values between 0 and 1 that specifies the x and y value of the center of the text. The uppercase values correspond to the position without margins (so tighter to the frame). The default value is controlled by the argument \code{"attr.position"} of \code{\link{tm_layout}}.}

\item{just}{Justification of the attribute relative to the point coordinates.  The first value specifies horizontal and the second value vertical justification. Possible values are: \code{"left"} , \code{"right"}, \code{"center"}, \code{"bottom"}, and \code{"top"}. Numeric values of 0 specify left/bottom alignment and 1 right/top alignment. This option is only used, if \code{position} is specified by numeric coordinates. The default value is controlled by the argument \code{"attr.just"} of \code{\link{tm_layout}}.}
}
\description{
Creates a map logo. Multiple logos can be specified which are shown next to each other. Logos placed on top of each other can be specified with stacking \code{tm_logo} elements.
}
\examples{
\dontrun{
data(NLD_muni, NLD_prov)

tm_shape(NLD_muni) +
	tm_polygons("origin_native", border.alpha=0.5, style="cont", title="Native Dutch (\%)") +
	tm_logo("http://statline.cbs.nl/Statweb/Images/cbs_logo.png", 
        position=c("left", "bottom"), height = 2) +
	tm_layout(bg.color="gray98")

data(World)

tm_shape(World) +
	tm_polygons("HPI", palette="RdYlGn", auto.palette.mapping=FALSE) +
	tm_logo(c("https://www.r-project.org/logo/Rlogo.png", 
        system.file("img/tmap.png", package="tmap"))) +
	tm_logo("http://blog.kulikulifoods.com/wp-content/uploads/2014/10/logo.png", 
        height=5, position = c("left", "top")) +
	tm_format_World()
}
}

