% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_layout.R
\name{tm_layout}
\alias{tm_format_Europe}
\alias{tm_format_Europe_wide}
\alias{tm_format_NLD}
\alias{tm_format_NLD_wide}
\alias{tm_format_World}
\alias{tm_format_World_wide}
\alias{tm_layout}
\alias{tm_legend}
\alias{tm_style_albatross}
\alias{tm_style_beaver}
\alias{tm_style_bw}
\alias{tm_style_classic}
\alias{tm_style_cobalt}
\alias{tm_style_col_blind}
\alias{tm_style_gray}
\alias{tm_style_grey}
\alias{tm_style_natural}
\alias{tm_style_white}
\title{Layout of cartographic maps}
\usage{
tm_layout(title = NA, scale = 1, title.size = 1.3, bg.color = "white",
  aes.color = c(fill = "grey85", borders = "grey40", bubbles = "blueviolet",
  dots = "black", lines = "red", text = "black", na = "grey70"),
  aes.palette = list(seq = "YlOrBr", div = "RdYlGn", cat = "Set3"),
  attr.color = "black", sepia.intensity = 0, saturation = 1,
  frame = TRUE, frame.lwd = 1, frame.double.line = FALSE, asp = NA,
  outer.margins = rep(0.02, 4), inner.margins = NA, between.margin = 0.5,
  outer.bg.color = NULL, fontface = "plain", fontfamily = "",
  compass.type = "arrow", earth.boundary = FALSE,
  earth.boundary.color = attr.color, earth.boundary.lwd = 1,
  earth.datum = "WGS84", space.color = NULL, legend.show = TRUE,
  legend.only = FALSE, legend.outside = NA,
  legend.outside.position = "right", legend.outside.size = 0.3,
  legend.position = NULL, legend.width = 0.4, legend.height = 0.9,
  legend.hist.height = 0.3, legend.hist.width = legend.width,
  legend.title.size = 1.1, legend.text.size = 0.7, legend.hist.size = 0.7,
  legend.format = list(scientific = FALSE, digits = NA, text.separator = "to",
  text.less.than = "Less than", text.or.more = "or more"),
  legend.frame = FALSE, legend.text.color = attr.color,
  legend.bg.color = NA, legend.bg.alpha = 1, legend.hist.bg.color = NA,
  legend.hist.bg.alpha = 1, title.snap.to.legend = FALSE,
  title.position = c("left", "top"), title.color = attr.color,
  title.bg.color = NA, title.bg.alpha = 1, panel.show = NA,
  panel.label.size = 1, panel.label.color = "black",
  panel.label.bg.color = "grey80", panel.label.height = 1.25,
  panel.label.rot = c(90, 0), attr.position = c("right", "bottom"),
  design.mode = FALSE, basemaps = c("CartoDB.Positron", "OpenStreetMap",
  "Esri.WorldTopoMap"), bg.overlay = NULL, bg.overlay.alpha = 0)

tm_legend(...)

tm_format_World(title = NA, inner.margins = c(0, 0.05, 0.025, 0.01),
  legend.position = c("left", "bottom"), attr.position = c("right",
  "bottom"), scale = 0.8, ...)

tm_format_World_wide(title = NA, inner.margins = c(0, 0.2, 0.025, 0.01),
  legend.position = c("left", "bottom"), attr.position = c("right",
  "bottom"), scale = 0.8, ...)

tm_format_Europe(title = NA, title.position = c("left", "top"),
  legend.position = c("left", "top"), attr.position = c("left", "bottom"),
  inner.margins = c(0, 0.1, 0, 0), ...)

tm_format_Europe_wide(title = NA, title.position = c("left", "top"),
  legend.position = c("left", "top"), attr.position = c("left", "bottom"),
  inner.margins = c(0, 0.25, 0, 0), ...)

tm_format_NLD(title = NA, frame = FALSE, inner.margins = c(0.02, 0.2,
  0.06, 0.02), legend.position = c("left", "top"), attr.position = c("left",
  "bottom"), ...)

tm_format_NLD_wide(title = NA, frame = FALSE, inner.margins = c(0.02, 0.3,
  0.06, 0.02), legend.position = c("left", "top"), attr.position = c("left",
  "bottom"), ...)

tm_style_white(...)

tm_style_gray(bg.color = "grey85", aes.color = c(fill = "grey70", borders =
  "grey20", bubbles = "blueviolet", dots = "black", lines = "red", text =
  "black", na = "grey60"), ...)

tm_style_natural(bg.color = "lightskyblue1", aes.color = c(fill =
  "darkolivegreen3", borders = "black", bubbles = "tomato2", dots = "firebrick",
  lines = "steelblue", text = "black", na = "white"), aes.palette = list(seq =
  "YlGn", div = "RdYlGn", cat = "Set3"), attr.color = "black",
  space.color = "white", earth.boundary = TRUE,
  basemaps = "MapQuestOpen.OSM", ...)

tm_style_grey(bg.color = "grey85", aes.color = c(fill = "grey70", borders =
  "grey20", bubbles = "blueviolet", dots = "black", lines = "red", text =
  "black", na = "grey60"), ...)

tm_style_cobalt(bg.color = "#002240", aes.color = c(fill = "#0088FF",
  borders = "#002240", bubbles = "#FF9D00", dots = "#FF9D00", lines = "#FFEE80",
  text = "white", na = "grey60"), aes.palette = list(seq = "YlGn", div =
  "RdYlGn", cat = "Set3"), attr.color = "white", bg.overlay.alpha = 0.3,
  ...)

tm_style_col_blind(bg.color = "white", aes.color = c(fill = "grey85",
  borders = "black", bubbles = "#D55E00", dots = "#0072B2", lines = "#009E73",
  text = "black", na = "white"), aes.palette = list(seq = "Blues", div =
  "RdBu", cat = c("#D55E00", "#56B4E9", "#E69F00", "#009E73", "#F0E442",
  "#0072B2", "#CC79A7")), attr.color = "black", ...)

tm_style_albatross(bg.color = "#00007F", aes.color = c(fill = "#4C4C88",
  borders = "#00004C", bubbles = "#BFBFFF", dots = "#BFBFFF", lines = "#BFBFFF",
  text = "#FFE700", na = "grey60"), aes.palette = list(seq = "YlOrRd", div =
  "RdYlGn", cat = "Set3"), attr.color = "#BFBFFF", bg.overlay.alpha = 0.3,
  ...)

tm_style_beaver(bg.color = "#FFFFFF", aes.color = c(fill = "#FFE200",
  borders = "#000000", bubbles = "#A30000", dots = "#A30000", lines = "#A30000",
  text = "#000000", na = "#E0E0E0"), aes.palette = list(seq = "YlOrBr", div =
  "RdYlGn", cat = "Dark2"), attr.color = "black", ...)

tm_style_bw(saturation = 0, ...)

tm_style_classic(sepia.intensity = 0.7, fontfamily = "serif",
  frame.double.line = TRUE, compass.type = "rose", bg.overlay = "gold",
  bg.overlay.alpha = 0.5, basemaps = "Esri.WorldTopoMap", ...)
}
\arguments{
\item{title}{Title(s). By default, the name of the statistical variable of which the legend is drawn at the top (see \code{legend.config}) is used as a title.}

\item{scale}{numeric value that serves as the global scale parameter. All font sizes, bubble sizes, border widths, and line widths are controled by this value. Each of these elements can be scaled independantly with the \code{scale}, \code{lwd}, or \code{size} arguments provided by the \code{\link{tmap-element}s}.}

\item{title.size}{Relative size of the title}

\item{bg.color}{Background color. By default it is \code{"white"}. A recommended alternative for choropleths is light grey (e.g., \code{"grey85"}).}

\item{aes.color}{Default color values for the aesthetics layers. Should be a named vector with the names chosen from: \code{fill}, \code{borders}, \code{bubbles}, \code{dots}, \code{lines}, \code{text}, \code{na}. Use \code{"#00000000"} for transparency.}

\item{aes.palette}{Default color palettes for the aesthetics. It takes a list of three items: \code{seq} for sequential palettes, \code{div} for diverging palettes, and \code{cat} for categorical palettes. By default, Color Brewer palettes (see (see \code{RColorBrewer::display.brewer.all})) are used. It is also possible provide a vector of colors for any of these items.}

\item{attr.color}{Default color value for map attributes}

\item{sepia.intensity}{Number between 0 and 1 that defines the amount of sepia effect, which gives the map a brown/yellowish flavour. By default this effect is disabled (\code{sepia.intensity=0}). All colored used in the map are adjusted with this effect.}

\item{saturation}{Number that determines how much saturation (also known as chroma) is used: \code{saturation=0} is greyscale and \code{saturation=1} is normal. A number larger than 1 results in very saturated maps. All colored used in the map are adjusted with this effect. Hacking tip: use a negative number.}

\item{frame}{Either a boolean that determines whether a frame is drawn, or a color value that specifies the color of the frame.}

\item{frame.lwd}{width of the frame}

\item{frame.double.line}{draw a double frame line border?}

\item{asp}{Aspect ratio. The aspect ratio of the map (width/height). If \code{NA}, it is determined by the bounding box (see argument \code{bbox} of \code{\link{tm_shape}}), the \code{outer.margins}, and the \code{inner.margins}. If \code{0}, then the aspect ratio is adjusted to the aspect ratio of the device.}

\item{outer.margins}{Relative margins between device and frame. Vector of four values specifying the bottom, left, top, and right margin. Values are between 0 and 1. When facets are created, the outer margins are the margins between the outer panels and the device borders (see also \code{between.margin})}

\item{inner.margins}{Relative margins inside the frame. Vector of four values specifying the bottom, left, top, and right margin. Values are between 0 and 1. By default, 0 for each side if master shape is a raster, otherwise 0.02.}

\item{between.margin}{Margin between facets (small multiples) in number of text line heights. The height of a text line is automatically scaled down based on the number of facets.}

\item{outer.bg.color}{Background color outside the frame.}

\item{fontface}{font face of all text in the map.}

\item{fontfamily}{font family of the text labels.}

\item{compass.type}{type of compass, one of: \code{"arrow"}, \code{"4star"}, \code{"8star"}, \code{"radar"}, \code{"rose"}. Of course, only applicable if a compass is shown. The compass type can also be set within \code{\link{tm_compass}}.}

\item{earth.boundary}{Logical that determines whether the boundaries of the earth are shown or an object that specifies the boundaries. This object can be a vector of size four, a 2 by 2 matrix (bounding box), or an \code{\link[raster:extent]{extent}} object. By default, the boundaries are \code{c(-180, 180, -90, 90)}. Useful for rojected world maps. Often, it is useful to crop both poles (e.g., with \code{c(-180, 180, -88, 88)}).}

\item{earth.boundary.color}{Color of the earth boundary.}

\item{earth.boundary.lwd}{Line width of the earth boundary.}

\item{earth.datum}{Geodetic datum to determine the earth boundary. By default \code{"WGS84"}, other frequently used datums are \code{"NAD83"} and \code{"NAD27"}. Any other \code{PROJ.4} character string can be used.}

\item{space.color}{Color of the space, i.e. the region inside the frame, and outsise the earth boundary.}

\item{legend.show}{Logical that determines whether the legend is shown.}

\item{legend.only}{logical. Only draw the legend (without map)? Particularly useful for small multiples with a common legend.}

\item{legend.outside}{Logical that determines whether the legend is plot outside of the map/facets. Especially useful when using facets that have a common legend (i.e. with \code{free.scales=FALSE}).}

\item{legend.outside.position}{Character vector of two values that determine the outside position of the legend. Only applicable when \code{legend.outside=TRUE}. The first value determines the side of the map/facets, one of: \code{"right"}, \code{"left"}, \code{"top"}, or \code{"bottom"}. The second value determines the alignment of the legend, one of \code{"top"}, \code{"center"}, or \code{"bottom"} when the first value is \code{"left"} or \code{"right"}; one of \code{"left"}, \code{"center"}, \code{"right"} when the first value is \code{"top"} or \code{"bottom"}.}

\item{legend.outside.size}{Numeric value that determines the relative size of the legend, when \code{legend.outside=TRUE}. If the first value of \code{legend.outside.position} is \code{"top"} or \code{"bottom"}, then it is the width of the legend, else it is the height of the legend.}

\item{legend.position}{Position of the legend. Vector of two values, specifing the x and y coordinates. Either this vector contains "left", "LEFT", "center", "right", or "RIGHT" for the first value and "top", "TOP", "center", "bottom", or "BOTTOM" for the second value, or this vector contains two numeric values between 0 and 1 that specifies the x and y coordinates of the left bottom corner of the legend. The uppercase values correspond to the position without margins (so tighter to the frame). By default, it is automatically placed in the corner with most space based on the (first) shape object.}

\item{legend.width}{maximum width of the legend}

\item{legend.height}{maximum height of the legend.}

\item{legend.hist.height}{height of the histogram. This hight is initial. If the total legend is downscaled to \code{legend.height}, the histogram is downscaled as well.}

\item{legend.hist.width}{width of the histogram. By default, it is equal to the \code{legend.width}.}

\item{legend.title.size}{Relative font size for the legend title}

\item{legend.text.size}{Relative font size for the legend text elements}

\item{legend.hist.size}{Relative font size for the choropleth histogram}

\item{legend.format}{list of formatting options for the legend numbers. Only applicable if \code{labels} is undefined. Parameters are:
\describe{
\item{scientific}{Should the labels be formatted scientically? If so, square brackets are used, and the \code{format} of the numbers is \code{"g"}. Otherwise, \code{format="f"}, and \code{text.separator}, \code{text.less.than}, and \code{text.or.more} are used. Also, the numbers are automatically  rounded to millions or billions if applicable.}
\item{format}{By default, \code{"f"}, i.e. the standard notation \code{xxx.xxx}, is used. If \code{scientific=TRUE} then \code{"g"}, which means that numbers are formatted scientically, i.e. \code{n.dddE+nn} if needed to save space.}
\item{digits}{Number of digits after the decimal point if \code{format="f"}, and the number of significant digits otherwise.}
\item{text.separator}{Character string to use to separate numbers in the legend (default: "to").}
\item{text.less.than}{Character string to use to translate "Less than" (which is the default).}
\item{text.or.more}{Character string to use to translate "or more" (which is the default). }
\item{...}{Other arguments passed on to \code{\link[base:formatC]{formatC}}}
}}

\item{legend.frame}{either a logical that determines whether the legend is placed inside a frame, or a color that directly specifies the frame border color. The width of the frame is automatically determined, but is upper-bounded by \code{legend.width}.}

\item{legend.text.color}{color of the legend text}

\item{legend.bg.color}{Background color of the legend. Use \code{TRUE} to match with the overall background color \code{bg.color}.}

\item{legend.bg.alpha}{Transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{legend.bg.color} is used (normally 1).}

\item{legend.hist.bg.color}{Background color of the histogram}

\item{legend.hist.bg.alpha}{Transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{legend.hist.bg.color} is used (normally 1).}

\item{title.snap.to.legend}{Logical that determines whether the title is part of the legend.}

\item{title.position}{Position of the title. Vector of two values, specifing the x and y coordinates. Either this vector contains "left", "LEFT", "center", "right", or "RIGHT" for the first value and "top", "TOP", "center", "bottom", or "BOTTOM" for the second value, or this vector contains two numeric values between 0 and 1 that specifies the x and y coordinates of the tile. The uppercase values correspond to the position without margins (so tighter to the frame). 
By default the title is placed on top of the legend (determined by \code{legend.position}).}

\item{title.color}{color of the title}

\item{title.bg.color}{background color of the title. Use \code{TRUE} to match with the overall background color \code{bg.color}.}

\item{title.bg.alpha}{Transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{title.bg.color} is used (normally 1).}

\item{panel.show}{Logical that determines if the map(s) are shown as panels. If \code{TRUE}, the title will be placed in the panel header instead of inside the map. By default, it is \code{TRUE} when small multiples are created with the \code{by} variable. (See \code{\link{tm_facets}})}

\item{panel.label.size}{Relative font size of the panel labels}

\item{panel.label.color}{Font color of the panel labels}

\item{panel.label.bg.color}{Background color of the panel labels}

\item{panel.label.height}{Height of the labels in number of text line heights.}

\item{panel.label.rot}{Rotation angles of the panel labels. Vector of two values: the first is the rotation angle (in degrees) of the row panels, which are only used in cross-table facets (when \code{\link{tm_facets}}'s \code{by} is specified with two variables). The second is the rotation angle of the column panels.}

\item{attr.position}{Position of the map attributes, which are \code{\link{tm_credits}}, \code{\link{tm_scale_bar}} and \code{\link{tm_compass}}. Vector of two values, specifing the x and y coordinates. The first value is "left", "LEFT", "center", "right", or "RIGHT", and the second value "top", "TOP", "center", "bottom", or "BOTTOM". The uppercase values correspond to the position without margins (so tighter to the frame). Positions can also be set separately in the map attribute fuctions.}

\item{design.mode}{Logical that enables the design mode. If \code{TRUE}, inner and outer margins, legend position, aspect ratio are explicitely shown. Also, feedback text in the console is given.}

\item{basemaps}{vector of one or more names of baselayer maps used in the interactive view mode. See \code{\link{tm_view}}.}

\item{bg.overlay}{color of the background overlay rectangle used in the interactive view mode. See \code{\link{tm_view}}.}

\item{bg.overlay.alpha}{alpha transparency of \code{bg.overlay}}

\item{...}{other arguments from \code{tm_layout}}
}
\description{
This element specifies the map layout. The main function \code{tm_layout} controlls title, margins, aspect ratio, colors, frame, legend, among many other things. The function \code{tm_legend} is a shortcut to access all \code{legend.} arguments without this prefix. The other functions are wrappers for two purposes: the \code{tm_format_} functions specify position related layout settings such as margins, and the \code{tm_style_} functions specify general styling related layout settings such as colors and font. Typically, the former functions are shape dependent, and the latter functions are shape independent. See details for predefined styles and formats. With the global option \code{tmap.style}, a default style can be specified. Multiple \code{tm_layout} elements (or wrapper functions) can be stacked: called arguments will be overwritten.
}
\details{
Predefined styles:
\tabular{ll}{
\code{tm_style_white}\tab White background, commonly used colors (default) \cr
\code{tm_style_grey}/\code{_grey}\tab Grey background, useful to highlight sequential palettes (e.g. in choropleths) \cr
\code{tm_style_natural}\tab Emulation of natural view: blue waters and green land \cr
\code{tm_style_bw}\tab Greyscale, obviously useful for greyscale printing \cr
\code{tm_style_classic}\tab Classic styled maps (recommended) \cr
\code{tm_style_cobalt}\tab Inspired by latex beamer style cobalt \cr
\code{tm_style_albatross}\tab Inspired by latex beamer style cobalt \cr
\code{tm_style_beaver}\tab Inspired by latex beamer style beaver \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}

Predefined formats
\tabular{ll}{
\code{tm_format_World}\tab Format specified for world maps \cr
\code{tm_format_World_wide}\tab Format specified for world maps with more space for the legend \cr
\code{tm_format_Europe}\tab Format specified for maps of Europe \cr
\code{tm_format_Europe_wide}\tab Format specified for maps of Europe with more space for the legend \cr
\code{tm_format_NLD}\tab Format specified for maps of the Netherlands \cr
\code{tm_format_NLD_wide}\tab Format specified for maps of the Netherlands with more space for the legend \cr
--------------------------- \tab --------------------------------------------------------------------------------------------------- \cr
}
}
\examples{
data(World, land)

tm_shape(World) + 
    tm_fill("pop_est_dens", style="kmeans", title="Population density") +
tm_format_World(title="The World") + tm_style_albatross(frame.lwd=10)

\dontrun{
tm_shape(land) +
	tm_raster("elevation", breaks=c(-Inf, 250, 500, 1000, 1500, 2000, 2500, 3000, 4000, Inf),  
		palette = terrain.colors(9), title="Elevation", auto.palette.mapping = FALSE) +
tm_shape(World, is.master=TRUE) +
	tm_borders("grey20") +
	tm_grid(projection="longlat", labels.size = .5) +
	tm_text("name", size="AREA") +
tm_compass(position = c(.65, .15), color.light = "grey90") +
tm_credits("Eckert IV projection", position = c("right", "BOTTOM")) +
tm_layout(inner.margins=c(.04,.03, .02, .01), 
	earth.boundary = TRUE, 
	space.color="grey90") +
tm_style_classic(bg.color="lightblue") +
tm_legend(position = c("left", "bottom"), 
	frame = TRUE,
	bg.color="lightblue")
}
	
WorldOne <- rgeos::gUnaryUnion(World)
tm_shape(World, projection="wintri") +
	tm_fill("HPI", palette="div", auto.palette.mapping = FALSE, n=7, 
			title = "Happy Planet Index") +
tm_shape(WorldOne) + 
	tm_borders() +
	tm_grid(projection = "longlat") +
tm_credits("Winkel Tripel projection", position = c("right", "BOTTOM")) +
tm_style_natural(earth.boundary = c(-180,180,-87,87), inner.margins = .05) +
tm_legend(position=c("left", "bottom"), bg.color="grey95", frame=TRUE)

\dontrun{
# global option tmap.style:
qtm(World, fill="economy", format="World")
tmap_style("col_blind")
qtm(World, fill="economy", format="World")
tmap_style("cobalt")
qtm(World, fill="economy", format="World")
tmap_style("white")
}

# TIP: check out these examples in view mode, enabled with tmap_mode("view")

}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

