% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_coloring.R
\name{map_coloring}
\alias{map_coloring}
\title{Map coloring}
\usage{
map_coloring(x, algorithm = "greedy", ncols = NA, minimize = FALSE,
  palette = NULL, contrast = 1)
}
\arguments{
\item{x}{Either a \code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygons(DataFrame)}} or an adjacency list.}

\item{algorithm}{currently, only "greedy" is implemented.}

\item{ncols}{number of colors. By default it is 8 when \code{palette} is undefined. Else, it is set to the length of \code{palette}}

\item{minimize}{logical that determines whether \code{algorithm} will search for a minimal number of colors. If \code{FALSE}, the \code{ncols} colors will be picked by a random procedure.}

\item{palette}{color palette.}

\item{contrast}{vector of two numbers that determine the range that is used for sequential and diverging palettes (applicable when \code{auto.palette.mapping=TRUE}). Both numbers should be between 0 and 1. The first number determines where the palette begins, and the second number where it ends. For sequential palettes, 0 means the brightest color, and 1 the darkest color. For diverging palettes, 0 means the middle color, and 1 both extremes. If only one number is provided, this number is interpreted as the endpoint (with 0 taken as the start).}
}
\value{
If \code{palette} is defined, a vector of colors is returned, otherwise a vector of color indices.
}
\description{
Color the polygons of a map such that adjacent polygons have different colors
}
\examples{
\dontrun{
qtm(World, fill="MAP_COLORS", fill.palette="Pastel2")
tm_shape(World) +
  tm_polygons("MAP_COLORS", palette="Pastel2")
}
data(World, metro)

World$color <- map_coloring(World, palette="Pastel2")
qtm(World, fill = "color")

# map_coloring used indirectly:
qtm(World, fill = "MAP_COLORS")
}

