% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmap_mode.R
\name{tmap_options}
\alias{tmap_options}
\title{Options for tmap}
\usage{
tmap_options(...)
}
\arguments{
\item{...}{tmap options, using name = value. See below for the available tmap options. Alternatively, a named list can be provided.}
}
\description{
Get or set global options for tmap. The behaviour is similar to \code{\link[base:options]{options}}: all tmap options are retrieved when this function is called without arguments. When arguments are specified, the corresponding options are set, and the old values are silently returned.
}
\details{
The following tmap options exist:
\describe{
\item{tmap.unit}{This is the default value for the \code{unit} argument of \code{\link{tm_shape}}. It specifies the unit of measurement, which is used in the scale bar and the calculation of density values. By default (when loading the package), it is \code{"metric"}. Other valid values are \code{"imperial"}, \code{"km"}, \code{"m"}, \code{"mi"}, and \code{"ft"}.}
\item{tmap.style}{This option determines the current style. See \code{\link{tmap_style}} for details.}
\item{tmap.mode}{This options determines the current mode. See \code{\link{tmap_mode}} for details.}
\item{tmap.limits}{This option determines how many facets (small multiples) are allowed for per mode. It should be a vector of two numeric values named \code{facets.view} and \code{facets.plot}. By default (i.e. when loading the package), it is set to \code{c(facets.view = 4, facets.plot = 64)}}
}
}
\examples{
# save current options
current_options <- tmap_options()

# show current options
tmap_options()

# switch to other view
ttm()

# show current options
tmap_options()

# set style to cobalt
tmap_options(tmap.style = "cobalt")

# show current options
tmap_options()

# set style usign tmap_style
tmap_style("classic")

# show current options
tmap_options()

# set unit to imperial
tmap_options(tmap.unit = "imperial", tmap.limits = c(facets.view = 8, facets.plot = 16))

# show current options
tmap_options()

# restore options
tmap_options(current_options)
}
\seealso{
\code{\link{tmap_mode}}, \code{\link{tmap_style}}
}
