% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_p.R
\name{write_p}
\alias{write_p}
\title{Format a p-value for display}
\usage{
write_p(x, digits = 2)
}
\arguments{
\item{x}{A length-1 numeric or a list-like object with element named \code{p.value} (such as an htest object)}

\item{digits}{Number of digits to round to (default to 2)}
}
\value{
Returns a LaTeX-formatted string to report a p-value to the specified number of digits.
}
\description{
\code{write_p} formats a p-value for display in an RMarkdown document.
}
\details{
If x < 10^(-digits), then the result is the string p < 10^(-digits) in decimal notation.
}
\examples{
write_p(0.2345)

write_p(0.000234)

x = rnorm(10)
test1 = t.test(x)
write_p(test1)

}
