% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_prior_data.R
\name{create_prior_data}
\alias{create_prior_data}
\title{Creates input data frame for construction of MAP prior}
\usage{
create_prior_data(study_label = NULL, n_total, est, se)
}
\arguments{
\item{study_label}{An optional vector containing trial labels.}

\item{n_total}{A vector containing total sample sizes.}

\item{est}{A vector containing treatment effect estimates.}

\item{se}{A vector containing standard errors of the effect estimates.}
}
\value{
A data frame containing data on the trials in the source population.
}
\description{
Assembling information from trials in the source population in a structured way (required as a pre-processing step for MAP prior creation).
}
\examples{
prior_data <- create_prior_data(
  n_total = c(160, 240, 320),
  est = c(1.23, 1.40, 1.51),
  se = c(0.4, 0.36, 0.31)
)
}
\seealso{
\code{\link{create_new_trial_data}}, \code{\link{create_posterior_data}}
}
