% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{run_test_file}
\alias{run_test_file}
\title{Run an R file containing tests; gather results}
\usage{
run_test_file(file, at_home = TRUE, verbose = getOption("tt.verbose",
  TRUE), color = getOption("tt.pr.color", TRUE))
}
\arguments{
\item{file}{\code{[character]} File location of a .R file.}

\item{at_home}{\code{[logical]} toggle local tests.}

\item{verbose}{\code{[logical]} toggle verbosity during execution}

\item{color}{\code{[logical]} toggle colorize counts in verbose mode (see Note)}
}
\value{
A \code{list} of class \code{tinytests}, which is a list 
   of \code{\link{tinytest}} objects.
}
\description{
Run an R file containing tests; gather results
}
\details{
In \pkg{tinytest}, a test file is just an R script where some or all
of the statements express an \code{\link[=expect_equal]{expectation}}. 
\code{run_test_file} runs the file while gathering results of the
expectations in a data frame.
}
\note{
Not all terminals support ansi escape characters, so colorized output can be
switched off. This can also be done globally by setting \code{options(tt.pr.color=FALSE)}.
Some terminals that do support ansi escape characters may contain
bugs. An example is the RStudio terminal (RStudio 1.1) running on Ubuntu 16.04 
(and possibly other OSs).
}
\examples{
# create a test file, in temp directory
tests <- "
addOne <- function(x) x + 2

expect_true(addOne(0) > 0)
expect_equal(2, addOne(1))
"
testfile <- tempfile(pattern="test_", fileext=".R")
write(tests, testfile)

# run test file
out <- run_test_file(testfile,color=FALSE)
out
# print everything in short format, include passes in print.
print(out, nlong=0, passes=TRUE)

}
\seealso{
Other test-files: \code{\link{build_install_test}},
  \code{\link{run_test_dir}},
  \code{\link{summary.tinytests}},
  \code{\link{test_package}}
}
\concept{test-files}
