% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{tinytest}
\alias{tinytest}
\title{Tinytest constructor}
\usage{
tinytest(result, call, diff = NA_character_, short = NA_character_,
  file = NA_character_, fst = NA_integer_, lst = NA_integer_, ...)
}
\arguments{
\item{result}{\code{[logical]} scalar.}

\item{call}{\code{[call]} The call that created \code{result}.}

\item{diff}{\code{[character]} difference between current and target value
(if any).}

\item{short}{\code{[character]} short description of the difference}

\item{file}{\code{[character]} File location of the test.}

\item{fst}{\code{[integer]} First line number in the test file.}

\item{lst}{\code{[integer]} Last line number in the test file (differs
from \code{fst} if the call spans multiple lines).}

\item{label}{\code{[character]} a user-defined label.}
}
\value{
A \code{tinytest} object.
}
\description{
Each individual test in the package generates a \code{tinytest} object.
A \code{tinytest} object behaves like a \code{logical} scalar, but
it is endowed with attributes allowing to trace back where the test
was run.
}
\examples{
tt <- expect_equal(2, 1+1)
if (isTRUE(tt)){ 
  print("w00p w00p!") 
} else { 
  print("Oh no!") 
}



}
\keyword{internal}
