% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinyplot.R
\name{tinyplot}
\alias{tinyplot}
\alias{tinyplot.default}
\alias{tinyplot.formula}
\alias{tinyplot.density}
\alias{plt}
\title{Lightweight extension of the base R plotting function}
\usage{
tinyplot(x, ...)

\method{tinyplot}{default}(
  x = NULL,
  y = NULL,
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL,
  by = NULL,
  facet = NULL,
  facet.args = NULL,
  data = NULL,
  type = NULL,
  legend = NULL,
  main = NULL,
  sub = NULL,
  xlab = NULL,
  ylab = NULL,
  ann = par("ann"),
  xlim = NULL,
  ylim = NULL,
  axes = TRUE,
  xaxt = NULL,
  yaxt = NULL,
  xaxs = NULL,
  yaxs = NULL,
  xaxb = NULL,
  yaxb = NULL,
  xaxl = NULL,
  yaxl = NULL,
  log = "",
  flip = FALSE,
  frame.plot = NULL,
  grid = NULL,
  palette = NULL,
  pch = NULL,
  lty = NULL,
  lwd = NULL,
  col = NULL,
  bg = NULL,
  fill = NULL,
  alpha = NULL,
  cex = NULL,
  add = FALSE,
  draw = NULL,
  empty = FALSE,
  restore.par = FALSE,
  file = NULL,
  width = NULL,
  height = NULL,
  asp = NA,
  theme = NULL,
  ...
)

\method{tinyplot}{formula}(
  x = NULL,
  data = parent.frame(),
  facet = NULL,
  facet.args = NULL,
  type = NULL,
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL,
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  sub = NULL,
  xlab = NULL,
  ylab = NULL,
  ann = par("ann"),
  axes = TRUE,
  frame.plot = NULL,
  asp = NA,
  grid = NULL,
  pch = NULL,
  col = NULL,
  lty = NULL,
  lwd = NULL,
  restore.par = FALSE,
  formula = NULL,
  subset = NULL,
  na.action = NULL,
  drop.unused.levels = TRUE,
  ...
)

\method{tinyplot}{density}(x = NULL, type = c("l", "area"), ...)

plt(x, ...)
}
\arguments{
\item{x, y}{the x and y arguments provide the x and y coordinates for the
plot. Any reasonable way of defining the coordinates is acceptable; most
likely the names of existing vectors or columns of data frames. See the
'Examples' section below, or the function
\code{\link[grDevices]{xy.coords}} for details. If supplied separately, \code{x}
and \code{y} must be of the same length.}

\item{...}{other graphical parameters. If \code{type} is a character specification
(such as \code{"hist"}) then any argument names that match those from the corresponding
\verb{type_*()} function (such as \code{\link{type_hist}}) are passed on to that.
All remaining arguments from \code{...} can be further graphical parameters, see
\code{\link[graphics]{par}}).}

\item{xmin, xmax, ymin, ymax}{minimum and maximum coordinates of relevant area
or interval plot types. Only used when the \code{type} argument is one of
\code{"rect"} or \code{"segments"} (where all four min-max coordinates are required),
or \code{"pointrange"}, \code{"errorbar"}, or \code{"ribbon"} (where only \code{ymin} and
\code{ymax} required alongside \code{x}). In the formula method the arguments
can be specified as \code{ymin = var} if \code{var} is a variable in \code{data}.}

\item{by}{grouping variable(s). The default behaviour is for groups to be
represented in the form of distinct colours, which will also trigger an
automatic legend. (See \code{legend} below for customization options.) However,
groups can also be presented through other plot parameters (e.g., \code{pch},
\code{lty}, or \code{cex}) by passing an appropriate \code{"by"} keyword; see Examples.
Note that continuous (i.e., gradient) colour legends are also supported if
the user passes a numeric or integer to \code{by}. To group by multiple
variables, wrap them with \code{\link[base]{interaction}}.}

\item{facet}{the faceting variable(s) that you want arrange separate plot
windows by. Can be specified in various ways:
\itemize{
\item In "atomic" form, e.g. \code{facet = fvar}. To facet by multiple variables in
atomic form, simply interact them, e.g.
\code{interaction(fvar1, fvar2)} or \code{factor(fvar1):factor(fvar2)}.
\item As a one-sided formula, e.g. \code{facet = ~fvar}. Multiple variables can be
specified in the formula RHS, e.g. \code{~fvar1 + fvar2} or \code{~fvar1:fvar2}. Note
that these multi-variable cases are \emph{all} treated equivalently and
converted to \code{interaction(fvar1, fvar2, ...)} internally. (No distinction
is made between different types of binary operators, for example, and so
\code{f1+f2} is treated the same as \code{f1:f2}, is treated the same as \code{f1*f2},
etc.)
\item As a two-side formula, e.g. \code{facet = fvar1 ~ fvar2}. In this case, the
facet windows are arranged in a fixed grid layout, with the formula LHS
defining the facet rows and the RHS defining the facet columns. At present
only single variables on each side of the formula are well supported. (We
don't recommend trying to use multiple variables on either the LHS or RHS
of the two-sided formula case.)
\item As a special \code{"by"} convenience keyword, in which case facets will match
the grouping variable(s) passed to \code{by} above.
}}

\item{facet.args}{an optional list of arguments for controlling faceting
behaviour. (Ignored if \code{facet} is NULL.) Supported arguments are as
follows:
\itemize{
\item \code{nrow}, \code{ncol} for overriding the default "square" facet window
arrangement. Only one of these should be specified, but \code{nrow} will take
precedence if both are specified together. Ignored if a two-sided formula
is passed to the main \code{facet} argument, since the layout is arranged in a
fixed grid.
\item \code{free} a logical value indicating whether the axis limits (scales) for
each individual facet should adjust independently to match the range of
the data within that facet. Default is \code{FALSE}. Separate free scaling of
the x- or y-axis (i.e., whilst holding the other axis fixed) is not
currently supported.
\item \code{fmar} a vector of form \code{c(b,l,t,r)} for controlling the base margin
between facets in terms of lines. Defaults to the value of \code{tpar("fmar")},
which should be \code{c(1,1,1,1)}, i.e. a single line of padding around each
individual facet, assuming it hasn't been overridden by the user as part
their global \code{\link[tinyplot]{tpar}} settings. Note some automatic
adjustments are made for certain layouts, and depending on whether the plot
is framed or not, to reduce excess whitespace. See
\code{\link[tinyplot]{tpar}} for more details.
\item \code{cex}, \code{font}, \code{col}, \code{bg}, \code{border} for adjusting the facet title text
and background. Default values for these arguments are inherited from
\code{\link[tinyplot]{tpar}} (where they take a "facet." prefix, e.g.
\code{tpar("facet.cex")}). The latter function can also be used to set these
features globally for all \code{tinyplot} plots.
}}

\item{data}{a data.frame (or list) from which the variables in formula
should be taken. A matrix is converted to a data frame.}

\item{type}{character string or call to a \verb{type_*()} function giving the
type of plot desired.
\itemize{
\item NULL (default): Choose a sensible type for the type of \code{x} and \code{y} inputs
(i.e., usually \code{"p"}).
\item 1-character values supported by \code{\link[graphics]{plot}}:
\itemize{
\item \code{"p"} Points
\item \code{"l"} Lines
\item \code{"b"} Both points and lines
\item \code{"c"} Empty points joined by lines
\item \code{"o"} Overplotted points and lines
\item \code{"s"} Stair steps
\item \code{"S"} Stair steps
\item \code{"h"} Histogram-like vertical lines
\item \code{"n"} Empty plot over the extent of the data
}
\item \code{tinyplot}-specific types. These fall into several categories:
\itemize{
\item Shapes:
\itemize{
\item \code{"area"} / \code{\link[=type_area]{type_area()}}: Plots the area under the curve from \code{y} = 0 to \code{y} = f(\code{x}).
\item \code{"errorbar"} / \code{\link[=type_errorbar]{type_errorbar()}}: Adds error bars to points; requires \code{ymin} and \code{ymax}.
\item \code{"pointrange"} / \code{\link[=type_pointrange]{type_pointrange()}}: Combines points with error bars.
\item \code{"polygon"} / \code{\link[=type_polygon]{type_polygon()}}: Draws polygons.
\item \code{"polypath"} / \code{\link[=type_polypath]{type_polypath()}}: Draws a path whose vertices are given in \code{x} and \code{y}.
\item \code{"rect"} / \code{\link[=type_rect]{type_rect()}}: Draws rectangles; requires \code{xmin}, \code{xmax}, \code{ymin}, and \code{ymax}.
\item \code{"ribbon"} / \code{\link[=type_ribbon]{type_ribbon()}}: Creates a filled area between \code{ymin} and \code{ymax}.
\item \code{"segments"} / \code{\link[=type_segments]{type_segments()}}: Draws line segments between pairs of points.
\item \code{"text"} / \code{\link[=type_text]{type_text()}}: Add text annotations.
}
\item Visualizations:
\itemize{
\item \code{"barplot"} / \code{\link[=type_barplot]{type_barplot()}}: Creates a bar plot.
\item \code{"boxplot"} / \code{\link[=type_boxplot]{type_boxplot()}}: Creates a box-and-whisker plot.
\item \code{"density"} / \code{\link[=type_density]{type_density()}}: Plots the density estimate of a variable.
\item \code{"histogram"} / \code{\link[=type_histogram]{type_histogram()}}: Creates a histogram of a single variable.
\item \code{"jitter"} / \code{\link[=type_jitter]{type_jitter()}}: Jittered points.
\item \code{"qq"} / \code{\link[=type_qq]{type_qq()}}: Creates a quantile-quantile plot.
\item \code{"ridge"} / \code{\link[=type_ridge]{type_ridge()}}: Creates a ridgeline (aka joy) plot.
\item \code{"rug"} / \code{\link[=type_rug]{type_rug()}}: Adds a rug to an existing plot.
\item \code{"spineplot"} / \code{\link[=type_spineplot]{type_spineplot()}}: Creates a spineplot or spinogram.
\item \code{"violin"} / \code{\link[=type_violin]{type_violin()}}: Creates a violin plot.
}
\item Models:
\itemize{
\item \code{"loess"} / \code{\link[=type_loess]{type_loess()}}: Local regression curve.
\item \code{"lm"} / \code{\link[=type_lm]{type_lm()}}: Linear regression line.
\item \code{"glm"} / \code{\link[=type_glm]{type_glm()}}: Generalized linear model fit.
\item \code{"spline"} / \code{\link[=type_spline]{type_spline()}}: Cubic (or Hermite) spline interpolation.
}
\item Functions:
\itemize{
\item \code{\link[=type_abline]{type_abline()}}: line(s) with intercept and slope.
\item \code{\link[=type_hline]{type_hline()}}: horizontal line(s).
\item \code{\link[=type_vline]{type_vline()}}: vertical line(s).
\item \code{\link[=type_function]{type_function()}}: arbitrary function.
\item \code{\link[=type_summary]{type_summary()}}: summarize \code{y} by unique values of \code{x}.
}
}
}}

\item{legend}{one of the following options:
\itemize{
\item NULL (default), in which case the legend will be determined by the
grouping variable. If there is no group variable (i.e., \code{by} is NULL) then
no legend is drawn. If a grouping variable is detected, then an automatic
legend is drawn to the \emph{outer} right of the plotting area. Note that the
legend title and categories will automatically be inferred from the \code{by}
argument and underlying data.
\item A convenience string indicating the legend position. The string should
correspond to one of the position keywords supported by the base \code{legend}
function, e.g. "right", "topleft", "bottom", etc. In addition, \code{tinyplot}
supports adding a trailing exclamation point to these keywords, e.g.
"right!", "topleft!", or "bottom!". This will place the legend \emph{outside}
the plotting area and adjust the margins of the plot accordingly. Finally,
users can also turn off any legend printing by specifying "none".
\item Logical value, where TRUE corresponds to the default case above (same
effect as specifying NULL) and FALSE turns the legend off (same effect as
specifying "none").
\item A list or, equivalently, a dedicated \code{legend()} function with supported
legend arguments, e.g. "bty", "horiz", and so forth.
}}

\item{main}{a main title for the plot, see also \code{title}.}

\item{sub}{a subtitle for the plot.}

\item{xlab}{a label for the x axis, defaults to a description of x.}

\item{ylab}{a label for the y axis, defaults to a description of y.}

\item{ann}{a logical value indicating whether the default annotation (title
and x and y axis labels) should appear on the plot.}

\item{xlim}{the x limits (x1, x2) of the plot. Note that x1 > x2 is allowed
and leads to a ‘reversed axis’. The default value, NULL, indicates that
the range of the \code{finite} values to be plotted should be used.}

\item{ylim}{the y limits of the plot.}

\item{axes}{logical or character. Should axes be drawn (\code{TRUE} or \code{FALSE})?
Or alternatively what type of axes should be drawn: \code{"standard"} (with
axis, ticks, and labels; equivalent to \code{TRUE}), \code{"none"} (no axes;
equivalent to \code{FALSE}), \code{"ticks"} (only ticks and labels without axis line),
\code{"labels"} (only labels without ticks and axis line), \code{"axis"} (only axis
line and labels but no ticks). To control this separately for the two
axes, use the character specifications for \code{xaxt} and/or \code{yaxt}.}

\item{xaxt, yaxt}{character specifying the type of x-axis and y-axis,
respectively. See \code{axes} for the possible values.}

\item{xaxs, yaxs}{character specifying the style of the interval calculation
used for the x-axis and y-axis, respectively. See
\code{\link[graphics]{par}} for the possible values.}

\item{xaxb, yaxb}{numeric vector (or character vector, if appropriate) giving
the break points at which the axis tick-marks are to be drawn. Break points
outside the range of the data will be ignored if the associated axis
variable is categorical, or an explicit \code{x/ylim} range is given.}

\item{xaxl, yaxl}{a function or a character keyword specifying the format of
the x- or y-axis tick labels. Note that this is a post-processing step that
affects the \emph{appearance} of the tick labels only; use in conjunction with
\code{x/yaxb} if you would like to adjust the position of the tick marks too. In
addition to user-supplied formatting functions (e.g., \code{\link{format}},
\code{\link{toupper}}, \code{\link{abs}}, or other custom function), several convenience
keywords (or their symbol equivalents) are available for common formatting
transformations: \code{"percent"} (\code{"\%"}), \code{"comma"} (\code{","}), \code{"log"} (\code{"l"}),
\code{"dollar"} (\code{"$"}), \code{"euro"} (\code{"€"}), or \code{"sterling"} (\code{"£"}). See the
\code{\link{tinylabel}} documentation for examples.}

\item{log}{a character string which contains \code{"x"} if the x axis is to be
logarithmic, \code{"y"} if the y axis is to be logarithmic and \code{"xy"} or \code{"yx"}
if both axes are to be logarithmic.}

\item{flip}{logical. Should the plot orientation be flipped, so that the
y-axis is on the horizontal plane and the x-axis is on the vertical plane?
Default is FALSE.}

\item{frame.plot}{a logical indicating whether a box should be drawn around
the plot. Can also use \code{frame} as an acceptable argument alias.
The default is to draw a frame if both axis types (set via \code{axes}, \code{xaxt},
or \code{yaxt}) include axis lines.}

\item{grid}{argument for plotting a background panel grid, one of either:
\itemize{
\item a logical (i.e., \code{TRUE} to draw the grid), or
\item a panel grid plotting function like \code{grid()}.
Note that this argument replaces the \code{panel.first} and \code{panel.last}
arguments from base \code{plot()} and tries to make the process more seamless
with better default behaviour. The default behaviour is determined by (and
can be set globally through) the value of \code{tpar("grid")}.
}}

\item{palette}{one of the following options:
\itemize{
\item NULL (default), in which case the palette will be chosen according to
the class and cardinality of the "by" grouping variable. For non-ordered
factors or strings with a reasonable number of groups, this will inherit
directly from the user's default \code{\link[grDevices]{palette}} (e.g.,
"R4"). In other cases, including ordered factors and high cardinality, the
"Viridis" palette will be used instead. Note that a slightly restricted
version of the "Viridis" palette---where extreme color values have been
trimmed to improve visual perception---will be used for ordered factors
and continuous variables. In the latter case of a continuous grouping
variable, we also generate a gradient legend swatch.
\item A convenience string corresponding to one of the many palettes listed by
either \code{palette.pals()} or \code{hcl.pals()}. Note that the string can be
case-insensitive (e.g., "Okabe-Ito" and "okabe-ito" are both valid).
\item A palette-generating function. This can be "bare" (e.g.,
\code{palette.colors}) or "closed" with a set of named arguments (e.g.,
\code{palette.colors(palette = "Okabe-Ito", alpha = 0.5)}). Note that any
unnamed arguments will be ignored and the key \code{n} argument, denoting the
number of colours, will automatically be spliced in as the number of
groups.
\item A vector or list of colours, e.g. \code{c("darkorange", "purple", "cyan4")}.
If too few colours are provided for a discrete (qualitative) set of
groups, then the colours will be recycled with a warning. For continuous
(sequential) groups, a gradient palette will be interpolated.
}}

\item{pch}{plotting "character", i.e., symbol to use. Character, integer, or
vector of length equal to the number of categories in the \code{by} variable.
See \code{pch}. In addition, users can supply a special \code{pch = "by"} convenience
argument, in which case the characters will automatically loop over the
number groups. This automatic looping will begin at the global character
value (i.e., \code{par("pch")}) and recycle as necessary.}

\item{lty}{line type. Character, integer, or vector of length equal to the
number of categories in the \code{by} variable. See \code{lty}. In addition, users
can supply a special \code{lty = "by"} convenience argument, in which case the
line type will automatically loop over the number groups. This automatic
looping will begin at the global line type value (i.e., \code{par("lty")}) and
recycle as necessary.}

\item{lwd}{line width. Numeric scalar or vector of length equal to the
number of categories in the \code{by} variable. See \code{lwd}. In addition, users
can supply a special \code{lwd = "by"} convenience argument, in which case the
line width will automatically loop over the number of groups. This
automatic looping will be centered at the global line width value (i.e.,
\code{par("lwd")}) and pad on either side of that.}

\item{col}{plotting color. Character, integer, or vector of length equal to
the number of categories in the \code{by} variable. See \code{col}. Note that the
default behaviour in \code{tinyplot} is to vary group colors along any variables
declared in the \code{by} argument. Thus, specifying colors manually should not
be necessary unless users wish to override the automatic colors produced by
this grouping process. Typically, this would only be done if grouping
features are deferred to some other graphical parameter (i.e., passing the
"by" keyword to one of \code{pch}, \code{lty}, \code{lwd}, or \code{bg}; see below.)}

\item{bg}{background fill color for the open plot symbols 21:25 (see
\code{points.default}), as well as ribbon and area plot types.
Users can also supply either one of two special convenience arguments that
will cause the background fill to inherit the automatic grouped coloring
behaviour of \code{col}:
\itemize{
\item \code{bg = "by"} will insert a background fill that inherits the main color
mappings from \code{col}.
\item \verb{by = <numeric[0,1]>} (i.e., a numeric in the range \verb{[0,1]}) will insert
a background fill that inherits the main color mapping(s) from \code{col}, but
with added alpha-transparency.
}

For both of these convenience arguments, note that the (grouped) \code{bg}
mappings will persist even if the (grouped) \code{col} defaults are themselves
overridden. This can be useful if you want to preserve the grouped palette
mappings by background fill but not boundary color, e.g. filled points. See
examples.}

\item{fill}{alias for \code{bg}. If non-NULL values for both \code{bg} and \code{fill} are
provided, then the latter will be ignored in favour of the former.}

\item{alpha}{a numeric in the range \verb{[0,1]} for adjusting the alpha channel
of the color palette, where 0 means transparent and 1 means opaque. Use
fractional values, e.g. \code{0.5} for semi-transparency.}

\item{cex}{character expansion. A numerical vector (can be a single value)
giving the amount by which plotting characters and symbols should be scaled
relative to the default. Note that \code{NULL} is equivalent to 1.0, while \code{NA}
renders the characters invisible. There are two additional considerations,
specifically for points-alike plot types (e.g. \code{"p"}):
\itemize{
\item users can also supply a special \code{cex = "by"} convenience argument, in
which case the character expansion will automatically adjust by group
too. The range of this character expansion is controlled by the \code{clim}
argument in the respective types; see \code{\link[=type_points]{type_points()}} for example.
\item passing a \code{cex} vector of equal length to the main \code{x} and \code{y} variables
(e.g., another column in the same dataset) will yield a "bubble"plot with
its own dedicated legend. This can provide a useful way to visualize an
extra dimension of the data; see Examples.
}}

\item{add}{logical. If TRUE, then elements are added to the current plot rather
than drawing a new plot window. Note that the automatic legend for the
added elements will be turned off. See also \link{tinyplot_add}, which provides
a convenient wrapper around this functionality for layering on top of an
existing plot without having to repeat arguments.}

\item{draw}{a function that draws directly on the plot canvas (before \code{x} and
\code{y} are plotted). The \code{draw} argument is primarily useful for adding common
elements to each facet of a faceted plot, e.g.
\code{\link[graphics]{abline}} or \code{\link[graphics]{text}}. Note that
this argument is somewhat experimental and that \emph{no} internal checking is
done for correctness; the provided argument is simply captured and
evaluated as-is. See Examples.}

\item{empty}{logical indicating whether the interior plot region should be
left empty. The default is \code{FALSE}. Setting to \code{TRUE} has a similar effect
to invoking \code{type = "n"} above, except that any legend artifacts owing to a
particular plot type (e.g., lines for \code{type = "l"} or squares for
\code{type = "area"}) will still be drawn correctly alongside the empty plot. In
contrast,\code{type = "n"} implicitly assumes a scatterplot and so any legend
will only depict points.}

\item{restore.par}{a logical value indicating whether the
\code{\link[graphics]{par}} settings prior to calling \code{tinyplot} should be
restored on exit. Defaults to FALSE, which makes it possible to add
elements to the plot after it has been drawn. However, note the the outer
margins of the graphics device may have been altered to make space for the
\code{tinyplot} legend. Users can opt out of this persistent behaviour by
setting to TRUE instead. See also \link{get_saved_par} for another option to
recover the original \code{\link[graphics]{par}} settings, as well as
longer discussion about the trade-offs involved.}

\item{file}{character string giving the file path for writing a plot to disk.
If specified, the plot will not be displayed interactively, but rather sent
to the appropriate external graphics device (i.e.,
\code{\link[grDevices]{png}}, \code{\link[grDevices]{jpeg}},
\code{\link[grDevices]{pdf}}, or \code{\link[grDevices]{svg}}). As a point
of convenience, note that any global parameters held in \verb{(t)par} are
automatically carried over to the external device and don't need to be
reset (in contrast to the conventional base R approach that requires
manually opening and closing the device). The device type is determined by
the file extension at the end of the provided path, and must be one of
".png", ".jpg" (".jpeg"), ".pdf", or ".svg". (Other file types may be
supported in the future.) The file dimensions can be controlled by the
corresponding \code{width} and \code{height} arguments below, otherwise will fall
back to the \code{"file.width"} and \code{"file.height"} values held in
\code{\link[tinyplot]{tpar}} (i.e., both defaulting to 7 inches, and where
the default resolution for bitmap files is also specified as 300
DPI).}

\item{width}{numeric giving the plot width in inches. Together with \code{height},
typically used in conjunction with the \code{file} argument above, overriding the
default values held in \code{tpar("file.width", "file.height")}. If either \code{width}
or \code{height} is specified, but a corresponding \code{file} argument is not
provided as well, then a new interactive graphics device dimensions will be
opened along the given dimensions. Note that this interactive resizing may
not work consistently from within an IDE like RStudio that has an integrated
graphics windows.}

\item{height}{numeric giving the plot height in inches. Same considerations as
\code{width} (above) apply, e.g. will default to \code{tpar("file.height")} if not
specified.}

\item{asp}{the y/xy/x aspect ratio, see \code{plot.window}.}

\item{theme}{keyword string (e.g. \code{"clean"}) or list defining a theme. Passed
on to \code{\link{tinytheme}}, but reset upon exit so that the theme effect is only
temporary. Useful for invoking ephemeral themes.}

\item{formula}{a \code{\link[stats]{formula}} that optionally includes
grouping variable(s) after a vertical bar, e.g. \code{y ~ x | z}. One-sided
formulae are also permitted, e.g. \code{~ y | z}. Only a single \code{y} and \code{x}
variable (if any) must be specified but multiple grouping variables
can be included in different ways, e.g. \code{y ~ x | z1:z2} or
\code{y ~ x | z1 + z2}. (These two representations are treated as equivalent;
both are parsed as \code{interaction(z1, z2)} internally.) If arithmetic
operators are used for transforming variables, they should be wrapped in
\code{I()}, e.g., \code{I(y1/y2) ~ x}. Note that the \code{formula} and \code{x} arguments
should not be specified in the same call.}

\item{subset, na.action, drop.unused.levels}{arguments passed to \code{model.frame}
when extracting the data from \code{formula} and \code{data}.}
}
\value{
No return value, called for side effect of producing a plot.
}
\description{
Enhances the base \code{\link[graphics]{plot}} function. Supported features
include automatic legends and facets for grouped data, additional plot types,
theme customization, and so on. Users can call either \code{tinyplot()}, or its
shorthand alias \code{plt()}.
}
\details{
Disregarding the enhancements that it supports, \code{tinyplot} tries as far as
possible to mimic the behaviour and syntax logic of the original base
\code{\link[graphics]{plot}} function. Users should therefore be able to swap
out existing \code{plot} calls for \code{tinyplot} (or its shorthand alias \code{plt}),
without causing unexpected changes to the output.
}
\examples{
aq = transform(
  airquality,
  Month = factor(Month, labels = month.abb[unique(Month)])
)

# In most cases, `tinyplot` should be a drop-in replacement for regular
# `plot` calls. For example:

op = tpar(mfrow = c(1, 2))
plot(0:10, main = "plot")
tinyplot(0:10, main = "tinyplot")
tpar(op) # restore original layout

# Aside: `tinyplot::tpar()` is a (near) drop-in replacement for `par()`

# Unlike vanilla plot, however, tinyplot allows you to characterize groups
# using either the `by` argument or equivalent `|` formula syntax.

with(aq, tinyplot(Day, Temp, by = Month)) ## atomic method
tinyplot(Temp ~ Day | Month, data = aq) ## formula method

# (Notice that we also get an automatic legend.)

# You can also use the equivalent shorthand `plt()` alias if you'd like to
# save on a few keystrokes

plt(Temp ~ Day | Month, data = aq) ## shorthand alias

# Use standard base plotting arguments to adjust features of your plot.
# For example, change `pch` (plot character) to get filled points and `cex`
# (character expansion) to increase their size.

tinyplot(
  Temp ~ Day | Month,
  data = aq,
  pch = 16,
  cex = 2
)

# Use the special "by" convenience keyword if you would like to map these
# aesthetic features over groups too (i.e., in addition to the default
# colour grouping)

tinyplot(
  Temp ~ Day | Month,
  data = aq,
  pch = "by",
  cex = "by"
)

# We can add alpha transparency for overlapping points

tinyplot(
  Temp ~ Day | Month,
  data = aq,
  pch = 16,
  cex = 2,
  alpha = 0.3
)

# To get filled points with a common solid background color, use an
# appropriate plotting character (21:25) and combine with one of the special
# `bg`/`fill` convenience arguments.
tinyplot(
  Temp ~ Day | Month,
  data = aq,
  pch = 21, # use filled circles
  cex = 2,
  bg = 0.3, # numeric in [0,1] adds a grouped background fill with transparency
  col = "black" # override default color mapping; give all points a black border
)

# Aside: For "bubble" plots, pass an appropriate vector to the `cex` arg.
# This can be useful for depicting an additional dimension of the data (here:
# Wind).
tinyplot(
  Temp ~ Day | Month,
  data = aq,
  pch = 21,
  cex = aq$Wind, # map character size to another feature in the data
  bg = 0.3,
  col = "black"
)

# Converting to a grouped line plot is a simple matter of adjusting the
# `type` argument.

tinyplot(
  Temp ~ Day | Month,
  data = aq,
  type = "l"
)

# Similarly for other plot types, including some additional ones provided
# directly by tinyplot, e.g. density plots or internal plots (ribbons,
# pointranges, etc.)

tinyplot(
  ~ Temp | Month,
  data = aq,
  type = "density",
  fill = "by"
)

# Facet plots are supported too. Facets can be drawn on their own...

tinyplot(
  Temp ~ Day,
  facet = ~Month,
  data = aq,
  type = "area",
  main = "Temperatures by month"
)

# ... or combined/contrasted with the by (colour) grouping.

aq = transform(aq, Summer = Month \%in\% c("Jun", "Jul", "Aug"))
tinyplot(
  Temp ~ Day | Summer,
  facet = ~Month,
  data = aq,
  type = "area",
  palette = "dark2",
  main = "Temperatures by month and season"
)

# Users can override the default square window arrangement by passing `nrow`
# or `ncol` to the helper facet.args argument. Note that we can also reduce
# axis label repetition across facets by turning the plot frame off.

tinyplot(
  Temp ~ Day | Summer,
  facet = ~Month, facet.args = list(nrow = 1),
  data = aq,
  type = "area",
  palette = "dark2",
  frame = FALSE,
  main = "Temperatures by month and season"
)

# Use a two-sided formula to arrange the facet windows in a fixed grid.
# LHS -> facet rows; RHS -> facet columns

aq$hot = ifelse(aq$Temp >= 75, "hot", "cold")
aq$windy = ifelse(aq$Wind >= 15, "windy", "calm")
tinyplot(
  Temp ~ Day,
  facet = windy ~ hot,
  data = aq
)

# To add common elements to each facet, use the `draw` argument

tinyplot(
  Temp ~ Day,
  facet = windy ~ hot,
  data = aq,
  draw = abline(h = 75, lty = 2, col = "hotpink")
)

# The (automatic) legend position and look can be customized using
# appropriate arguments. Note the trailing "!" in the `legend` position
# argument below. This tells `tinyplot` to place the legend _outside_ the plot
# area.

tinyplot(
  Temp ~ Day | Month,
  data = aq,
  type = "l",
  legend = legend("bottom!", title = "Month of the year", bty = "o")
)

# The default group colours are inherited from either the "R4" or "Viridis"
# palettes, depending on the number of groups. However, all palettes listed
# by `palette.pals()` and `hcl.pals()` are supported as convenience strings,
# or users can supply a valid palette-generating function for finer control

tinyplot(
  Temp ~ Day | Month,
  data = aq,
  type = "l",
  palette = "tableau"
)

# It's possible to customize the look of your plots by setting graphical
# parameters (e.g., via `(t)par`)... But a more convenient way is to just use
# built-in themes (see `?tinytheme`).

tinytheme("clean2")
tinyplot(
  Temp ~ Day | Month,
  data = aq,
  type = "b",
  alpha = 0.5,
  main = "Daily temperatures by month",
  sub = "Brought to you by tinyplot"
)
# reset the theme
tinytheme()

# For more examples and a detailed walkthrough, please see the introductory
# tinyplot tutorial available online:
# https://grantmcdermott.com/tinyplot/vignettes/introduction.html

}
