% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project}
\alias{project}
\title{Project tinyVAST to future times (EXPERIMENTAL)}
\usage{
project(
  object,
  extra_times,
  newdata,
  what = "mu_g",
  future_var = TRUE,
  past_var = FALSE,
  parm_var = FALSE
)
}
\arguments{
\item{object}{fitted model from \code{tinyVAST(.)}}

\item{extra_times}{a vector of extra times, matching values in \code{newdata}}

\item{newdata}{data frame including new values for \code{time_variable}}

\item{what}{What REPORTed object to output, where
\code{mu_g} is the inverse-linked transformed predictor including both linear components,
\code{p_g} is the first linear predictor,
\code{palpha_g} is the first predictor from fixed covariates in \code{formula},
\code{pgamma_g} is the first predictor from random covariates in \code{formula} (e.g., splines),
\code{pomega_g} is the first predictor from spatial variation,
\code{pepsilon_g} is the first predictor from spatio-temporal variation,
\code{pxi_g} is the first predictor from spatially varying coefficients,
\code{p2_g} is the second linear predictor,
\code{palpha2_g} is the second predictor from fixed covariates in \code{formula},
\code{pgamma2_g} is the second predictor from random covariates in \code{formula} (e.g., splines),
\code{pomega2_g} is the second predictor from spatial variation,
\code{pepsilon2_g} is the second predictor from spatio-temporal variation, and
\code{pxi2_g} is the second predictor from spatially varying coefficients.}

\item{future_var}{logical indicating whether to simulate future process errors
from GMRFs, or just compute the predictive mean}

\item{past_var}{logical indicating whether to re-simulate past process errors
from predictive distribution of random effects, thus changing the boundary
condition of the forecast}

\item{parm_var}{logical indicating whether to re-sample fixed effects from their
predictive distribution, thus changing the GMRF for future process errors}
}
\value{
A vector of values corresponding to rows in \code{newdata}
}
\description{
Projects a fitted model forward in time.
}
\examples{
# Convert to long-form
set.seed(123)
n_obs = 100
rho = 0.9
sigma_x = 0.2
sigma_y = 0.1
x = rnorm(n_obs, mean=0, sd = sigma_x)
for(i in 2:length(x)) x[i] = rho * x[i-1] + x[i]
y = x + rnorm( length(x), mean = 0, sd = sigma_y )
data = data.frame( "val" = y, "var" = "y", "time" = seq_along(y) )

# Define AR2 time_term
time_term = "
  y -> y, 1, rho1
  y -> y, 2, rho2
  y <-> y, 0, sd
"

# fit model
mytiny = tinyVAST(
  time_term = time_term,
  data = data,
  times = unique(data$t),
  variables = "y",
  formula = val ~ 1,
  control = tinyVASTcontrol( getJointPrecision = TRUE )
)

# Deterministic projection
extra_times = length(x) + 1:100
n_sims = 10
newdata = data.frame( "time" = c(seq_along(x),extra_times), "var" = "y" )
Y = project(
  mytiny,
  newdata = newdata,
  extra_times = extra_times,
  future_var = FALSE
)
plot( x = seq_along(Y),
      y = Y,
      type = "l", lty = "solid", col = "black" )

# Stochastic projection with future process errors
\dontrun{
extra_times = length(x) + 1:100
n_sims = 10
newdata = data.frame( "time" = c(seq_along(x),extra_times), "var" = "y" )
Y = NULL
for(i in seq_len(n_sims) ){
  tmp = project(
    mytiny,
    newdata = newdata,
    extra_times = extra_times,
    future_var = TRUE,
    past_var = TRUE,
    parm_var = TRUE
  )
  Y = cbind(Y, tmp)
}
matplot( x = row(Y),
         y = Y,
         type = "l", lty = "solid", col = "black" )
}

}
