% Generated by roxygen2 (4.0.2): do not edit by hand
\name{findSameSet}
\alias{findSameSet}
\title{Find the same columns from two matrices}
\usage{
findSameSet(profile, selected_list, kinase_name)
}
\arguments{
\item{profile}{the drug-target interaction data matrix}

\item{selected_list}{the selected drug-target matrix}

\item{kinase_name}{the names of the targets}
}
\value{
a vector of combined selected target names
}
\description{
A function to find the same columns from two matrices
}
\examples{
\dontrun{
data(tyner_interaction_binary)
data(tyner_sensitivity)
x<-data.frame(tyner_interaction_binary)
kinase_names<-dimnames(tyner_interaction_binary)
float<-sffsBinary(tyner_interaction_binary, tyner_sensitivity[,1])
k_select <- float$k_sel
select_kinase_names <- findSameSet(x, k_select, kinase_names)
}
}
\author{
Liye He \email{liye.he@helsinki.fi}
}

