% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{centerItem}
\alias{centerItem}
\title{Move the window such that given item or items are centered}
\usage{
centerItem(id, itemId, options)
}
\arguments{
\item{id}{Timeline id or a \code{timevis} object (the output from \code{timevis()})}

\item{itemId}{A vector (or single value) of the item ids to center}

\item{options}{Named list of options controlling mainly the animation.
Most common option is \code{"animation" = TRUE/FALSE}. For a full list of
options, see the "focus" method in the
\href{http://visjs.org/docs/timeline/#Methods}{official
Timeline documentation}}
}
\description{
Move the window such that given item or items are centered
}
\examples{

timevis(data.frame(
          id = 1:3,
          start = c(Sys.Date() - 1, Sys.Date(), Sys.Date() + 1),
          content = c("Item 1", "Item 2", "Item 3"))
) \%>\%
  centerItem(1)

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    actionButton("btn", "Center around item 1")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis(
        data.frame(id = 1:3,
          start = c(Sys.Date() - 1, Sys.Date(), Sys.Date() + 1),
          content = c("Item 1", "Item 2", "Item 3"))
      )
    )
    observeEvent(input$btn, {
      centerItem("timeline", 1)
    })
  }
)
}
}

