% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipes-step_log_interval.R
\name{step_log_interval}
\alias{step_log_interval}
\alias{tidy.step_log_interval}
\title{Log Interval Transformation for Constrained Interval Forecasting}
\usage{
step_log_interval(
  recipe,
  ...,
  limit_lower = "auto",
  limit_upper = "auto",
  offset = 0,
  role = NA,
  trained = FALSE,
  limit_lower_trained = NULL,
  limit_upper_trained = NULL,
  skip = FALSE,
  id = rand_id("log_interval")
)

\method{tidy}{step_log_interval}(x, ...)
}
\arguments{
\item{recipe}{A \code{recipe} object. The step will be added to the sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[=selections]{selections()}}
for more details. For the \code{tidy} method, these are not
currently used.}

\item{limit_lower}{A lower limit. Must be less than the minimum value.
If set to "auto", selects zero.}

\item{limit_upper}{An upper limit. Must be greater than the maximum value.
If set to "auto",  selects a value that is 10\% greater than the maximum value.}

\item{offset}{An offset to include in the log transformation.
Useful when the data contains values less than or equal to zero.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for preprocessing have been estimated.}

\item{limit_lower_trained}{A numeric vector of transformation values. This
is \code{NULL} until computed by \code{prep()}.}

\item{limit_upper_trained}{A numeric vector of transformation values. This
is \code{NULL} until computed by \code{prep()}.}

\item{skip}{A logical. Should the step be skipped when the recipe
is baked by \code{bake.recipe()}? While all operations are baked when \code{prep.recipe()} is run,
some operations may not be able to be conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_log_interval} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
selectors or variables selected) and \code{value} (the
lambda estimate).
}
\description{
\code{step_log_interval} creates a \emph{specification} of a recipe
step that will transform data using a Log-Inerval
transformation. This function provides a \code{recipes} interface
for the \code{log_interval_vec()} transformation function.
}
\details{
The \code{step_log_interval()} function is designed specifically to handle time series
using methods implemented in the Forecast R Package.

\strong{Positive Data}

If data includes values of zero, use \code{offset} to adjust the series to make the values positive.

\strong{Implementation}

Refer to the \code{\link[=log_interval_vec]{log_interval_vec()}} function for the transformation implementation details.
}
\examples{
library(dplyr)
library(recipes)

FANG_wide <- FANG \%>\%
    select(symbol, date, adjusted) \%>\%
    tidyr::pivot_wider(names_from = symbol, values_from = adjusted)

recipe_log_interval <- recipe(~ ., data = FANG_wide) \%>\%
    step_log_interval(FB, AMZN, NFLX, GOOG, offset = 1) \%>\%
    prep()

recipe_log_interval \%>\%
    bake(FANG_wide) \%>\%
    tidyr::pivot_longer(-date) \%>\%
    plot_time_series(date, value, name, .smooth = FALSE, .interactive = FALSE)

recipe_log_interval \%>\% tidy(1)

}
\seealso{
Time Series Analysis:
\itemize{
\item Engineered Features: \code{\link[=step_timeseries_signature]{step_timeseries_signature()}}, \code{\link[=step_holiday_signature]{step_holiday_signature()}}, \code{\link[=step_fourier]{step_fourier()}}
\item Diffs & Lags \code{\link[=step_diff]{step_diff()}}, \code{recipes::step_lag()}
\item Smoothing: \code{\link[=step_slidify]{step_slidify()}}, \code{\link[=step_smooth]{step_smooth()}}
\item Variance Reduction: \code{\link[=step_log_interval]{step_log_interval()}}
\item Imputation: \code{\link[=step_ts_impute]{step_ts_impute()}}, \code{\link[=step_ts_clean]{step_ts_clean()}}
\item Padding: \code{\link[=step_ts_pad]{step_ts_pad()}}
}

Transformations to reduce variance:
\itemize{
\item \code{recipes::step_log()} - Log transformation
\item \code{recipes::step_sqrt()} - Square-Root Power Transformation
}

Recipe Setup and Application:
\itemize{
\item \code{recipes::recipe()}
\item \code{recipes::prep()}
\item \code{recipes::bake()}
}
}
