% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_wikipedia_category_members.R
\name{tw_get_cached_wikipedia_category_members}
\alias{tw_get_cached_wikipedia_category_members}
\title{Gets members of Wikipedia categories from local cache}
\usage{
tw_get_cached_wikipedia_category_members(
  category,
  type = "page",
  language = tidywikidatar::tw_get_language(),
  cache = NULL,
  cache_connection = NULL,
  disconnect_db = TRUE
)
}
\arguments{
\item{category}{Title of a Wikipedia category page or final parts of its url.
Must include "Category:", or equivalent in other languages. If given, url
can be left empty, but language must be provided.}

\item{type}{Defaults to "page", defines which kind of members of a category
are returned. Valid values include "page", "file", and "subcat" (for
sub-category). Corresponds to \code{cmtype}. For details, see
\href{https://www.mediawiki.org/wiki/API:Categorymembers}{the relevant page
of the official documentation}.}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". Use "all_available" to keep all languages. For available
language values, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}
}
\value{
If data present in cache, returns a data frame with cached data.
}
\description{
Mostly used internally.
}
\examples{
if (interactive()) {
  tw_set_cache_folder(path = tempdir())
  tw_enable_cache()
  tw_create_cache_folder(ask = FALSE)

  df_from_api <- tw_get_wikipedia_page_qid(category = "Margaret Mead", language = "en")

  df_from_cache <- tw_get_cached_wikipedia_category_members(
    category = "Margaret Mead",
    language = "en"
  )

  df_from_cache
}
}
