% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_filter.R
\name{tw_filter_first}
\alias{tw_filter_first}
\title{Filter search result and keep only and keep only the first match}
\usage{
tw_filter_first(
  search,
  p,
  q,
  language = "en",
  limit = 10,
  wait = 0,
  cache = NULL
)
}
\arguments{
\item{search}{A data frame generated by \code{tw_search()}, or a search query. If a data frame is given, language and limits are ignore.}

\item{p}{A character vector of length 1, a property. Must always start with the capital letter "P", e.g. "P31" for "instance of".}

\item{q}{A character vector of length 1, a wikidata id. Must always start with the capital letter "Q", e.g. "Q5" for "human being".}

\item{language}{Language to be used for the search.}

\item{limit}{Maximum numbers of responses to be given.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied. If you are running many queries systematically you may want to add some waiting time between queries.}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}}
}
\value{
A data frame with one row and three columns, \code{id}, \code{label}, and \code{description}, filtered by the above criteria.
}
\description{
Same as \code{tw_filter()}, but consistently returns data frames with a single row.
}
\examples{
tw_search("Margaret Mead") \%>\%
  tw_filter_first(p = "P31", q = "Q5")
}
