% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequencies.R
\name{get_route_frequency}
\alias{get_route_frequency}
\title{Get Route Frequency}
\usage{
get_route_frequency(
  gtfs_obj,
  start_time = "06:00:00",
  end_time = "22:00:00",
  service_ids = NULL
)
}
\arguments{
\item{gtfs_obj}{a list of gtfs dataframes as read by the trread package.}

\item{start_time}{analysis start time, can be given as "HH:MM:SS",
hms object or numeric value in seconds.}

\item{end_time}{analysis perdiod end time, can be given as "HH:MM:SS",
hms object or numeric value in seconds.}

\item{service_ids}{A set of service_ids from the calendar dataframe
identifying a particular service id. If not provided, the service_id
with the most departures is used.}
}
\value{
a dataframe of routes with variables or headway/frequency in seconds for a route
within a given time frame
}
\description{
Calculate the number of departures and mean headways for routes within a given timespan
and for given service_ids.
}
\note{
Some GTFS feeds contain a frequency data frame already.
Consider using this instead, as it will be more accurate than what
tidytransit calculates.
}
\examples{
data(gtfs_duke)
routes_frequency <- get_route_frequency(gtfs_duke)
x <- order(routes_frequency$median_headways)
head(routes_frequency[x,])
}
