% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_spatvector.R
\name{ggspatvector}
\alias{ggspatvector}
\alias{geom_spatvector}
\alias{geom_spatvector_label}
\alias{geom_spatvector_text}
\title{Visualise SpatVector objects}
\usage{
geom_spatvector(mapping = aes(), data, na.rm = FALSE, show.legend = NA, ...)

geom_spatvector_label(
  mapping = aes(),
  data,
  na.rm = FALSE,
  show.legend = NA,
  ...
)

geom_spatvector_text(
  mapping = aes(),
  data,
  na.rm = FALSE,
  show.legend = NA,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{A SpatVector object, see \code{\link[terra:vect]{terra::vect()}}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.

You can also set this to one of "polygon", "line", and "point" to
override the default legend.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}.}
}
\value{
A ggplot2 layer
}
\description{
This geom is used to visualise SpatVector objects (see \code{\link[terra:vect]{terra::vect()}}). For
simple plots, you will only need \code{geom_spatvector()}. For text and labels,
you can use \code{geom_spatvector_text()} and\code{ geom_spatvector_label()}.

The underlying implementation is based on \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.
}
\details{
See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}} for details on aesthetics, etc.
}
\section{terra equivalent}{


\code{\link[terra:plot]{terra::plot()}}
}

\examples{
\donttest{
# Create a SpatVector

extfile <- system.file("extdata/cyl.gpkg", package = "tidyterra")

cyl <- terra::vect(extfile)
class(cyl)
#' # Create a SpatVector

extfile <- system.file("extdata/cyl.gpkg", package = "tidyterra")

cyl <- terra::vect(extfile)
class(cyl)

library(ggplot2)

ggplot() +
  geom_spatvector(data = cyl)

# Avoid this!
if (FALSE) {
  # Would produce an error

  ggplot(cyl) +
    geom_spatvector()
}
# With params

ggplot() +
  geom_spatvector(data = cyl, aes(fill = name), color = NA) +
  scale_fill_viridis_d() +
  coord_sf(crs = 3857)

# Add labels
ggplot() +
  geom_spatvector(data = cyl, aes(fill = name), color = NA) +
  geom_spatvector_text(
    data = cyl, aes(label = iso2), fontface = "bold", size = 3,
    color = "red"
  ) +
  scale_fill_viridis_d(alpha = 0.4) +
  coord_sf(crs = 3857)
}
}
\seealso{
\code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}

Other ggplot2 utils:
\code{\link{autoplot}()},
\code{\link{geom_spat_contour}},
\code{\link{geom_spatraster_rgb}()},
\code{\link{geom_spatraster}()}
}
\concept{ggplot2.utils}
