% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter.}
\alias{filter.}
\title{Filter rows on one or more conditions}
\usage{
filter.(.df, ..., .by = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Conditions to filter by}

\item{.by}{Columns to group by if filtering with a summary function}
}
\description{
Filters a dataset to choose rows where conditions are true.
}
\examples{
df <- tidytable(
  a = 1:3,
  b = 4:6,
  c = c("a", "a", "b")
)

df \%>\%
  filter(a >= 2, b >= 4)

df \%>\%
  filter(b <= mean(b), .by = c)
}
\keyword{internal}
