% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case_match.R
\name{case_match.}
\alias{case_match.}
\title{Vectorized \code{switch()}}
\usage{
case_match.(.x, ..., .default = NA, .ptype = NULL)
}
\arguments{
\item{.x}{A vector}

\item{...}{A sequence of two-sided formulas. The left hand side gives the old values,
the right hand side gives the new value.}

\item{.default}{The default value if all conditions evaluate to \code{FALSE}.}

\item{.ptype}{Optional ptype to specify the output type.}
}
\description{
Allows the user to more succinctly create conditions bu \code{case_when()}.
}
\examples{
df <- tidytable(x = c("a", "b", "c", "d"))

df \%>\%
  mutate(case_x = case_match(x,
                             c("a", "b") ~ "new_1",
                             "c" ~ "new_2",
                             .default = x))
}
\keyword{internal}
