% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill.R
\name{fill.}
\alias{fill.}
\title{Fill in missing values with previous or next value}
\usage{
fill.(.df, ..., .direction = c("down", "up", "downup", "updown"), .by = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{A selection of columns. \code{tidyselect} compatible.}

\item{.direction}{Direction in which to fill missing values.
Currently "down" (the default), "up", "downup" (first down then up), or "updown" (first up and then down)}

\item{.by}{Columns to group by when filling should be done by group}
}
\description{
Fills missing values in the selected columns using the next or previous entry. Can be done by group.

Supports tidyselect
}
\examples{
test_df <- data.table(
  a = c(1, NA, 3, 4, 5),
  b = c(NA, 2, NA, NA, 5),
  groups = c("a", "a", "a", "b", "b")
)

test_df \%>\%
  fill.(a, b)

test_df \%>\%
  fill.(a, b, .direction = "downup")

test_df \%>\%
  fill.(a, b, .direction = "downup", .by = groups)
}
