% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select.}
\alias{select.}
\title{Select or drop columns}
\usage{
select.(.df, ...)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to select or drop.
Use named arguments, e.g. new_name = old_name, to rename selected variables.
\code{tidyselect} compatible.}
}
\description{
Select or drop columns from a data.table
}
\examples{
test_df <- data.table(
  x = c(1,1,1),
  y = c(4,5,6),
  double_x = c(2,2,2),
  z = c("a","a","b"))

test_df \%>\%
  select.(x, y)

test_df \%>\%
  select.(x:z)

test_df \%>\%
  select.(-y, -z)

test_df \%>\%
  select.(starts_with("x"), z)

test_df \%>\%
  select.(where(is.character), x)

test_df \%>\%
  select.(stuff = x, y)
}
