% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest.R
\name{unnest.}
\alias{unnest.}
\title{Unnest a nested data.table}
\usage{
unnest.(
  .df,
  ...,
  .drop = TRUE,
  names_sep = NULL,
  names_repair = "unique",
  .keep_all = deprecated()
)
}
\arguments{
\item{.df}{A nested data.table}

\item{...}{Columns to unnest. If empty, unnests all list columns. \code{tidyselect} compatible.}

\item{.drop}{Should list columns that were not unnested be dropped}

\item{names_sep}{If NULL, the default, the inner column names will become the new outer column names.

If a string, the name of the outer column will be appended to the beginning of the inner column names,
with \code{names_sep} used as a separator.}

\item{names_repair}{Treatment of duplicate names. See \code{?vctrs::vec_as_names} for options/details.}

\item{.keep_all}{Deprecated. Please use \code{.drop = FALSE} to keep unused list columns.}
}
\description{
Unnest a nested data.table.
}
\examples{
nested_df <- data.table(
  a = 1:10,
  b = 11:20,
  c = c(rep("a", 6), rep("b", 4)),
  d = c(rep("a", 4), rep("b", 6))) \%>\%
  nest_by.(c, d) \%>\%
  mutate.(pulled_vec = map.(data, ~ pull.(.x, a)))

nested_df \%>\%
  unnest.(data)

nested_df \%>\%
  unnest.(data, names_sep = "_")

nested_df \%>\%
  unnest.(data, pulled_vec)
}
