% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{bind_cols.}
\alias{bind_cols.}
\alias{bind_rows.}
\title{Bind data.tables by row and column}
\usage{
bind_cols.(..., .name_repair = "unique")

bind_rows.(..., .id = NULL)
}
\arguments{
\item{...}{data.tables or data.frames to bind}

\item{.name_repair}{Treatment of duplicate names. See \code{?vctrs::vec_as_names} for options/details.}

\item{.id}{If TRUE, an integer column is made as a group id}
}
\description{
Bind multiple data.tables into one row-wise or col-wise.
}
\examples{
df1 <- data.table(x = c(1,2,3), y = c(3,4,5))
df2 <- data.table(x = c(1,2,3), y = c(3,4,5))

df1 \%>\%
  bind_rows.(df2)

bind_rows.(list(df1, df2))

df1 \%>\%
  bind_cols.(df2)

bind_cols.(list(df1, df2))
}
