% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete.R
\name{complete.}
\alias{complete.}
\title{Complete a data.table with missing combinations of data}
\usage{
complete.(.df, ..., .fill = list())
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to expand}

\item{.fill}{A named list of values to fill NAs with.}
}
\description{
Turns implicit missing values into explicit missing values.
}
\examples{
test_df <- data.table(x = 1:2, y = 1:2, z = 3:4)

test_df \%>\%
  complete.(x, y)

test_df \%>\%
  complete.(x, y, .fill = list(z = 10))
}
