% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_with.R
\name{rename_with.}
\alias{rename_with.}
\alias{dt_rename_with}
\title{Rename multiple columns}
\usage{
rename_with.(.data, .fn, .cols = everything.(), ...)

dt_rename_with(.data, .fn, .cols = everything.(), ...)
}
\arguments{
\item{.data}{A data.table or data.frame}

\item{.fn}{Function to transform the names with.}

\item{.cols}{Columns to rename. Defaults to all columns. \code{tidyselect} compatible.}

\item{...}{Other parameters to pass to the function}
}
\description{
Rename multiple columns with the same transformation
}
\examples{
example_dt <- data.table::data.table(
  x = 1,
  y = 2,
  double_x = 2,
  double_y = 4)

example_dt \%>\%
  rename_with.(~ sub("x", "stuff", .x))

example_dt \%>\%
  rename_with.(~ sub("x", "stuff", .x), .cols = c(x, double_x))
}
