% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{dt_group_nest}
\alias{dt_group_nest}
\title{Nest data.tables}
\usage{
dt_group_nest(.data, ..., .key = "data")
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{...}{bare column names to group by. If empty nests the entire data.table}

\item{.key}{Name of the new column created by nesting}
}
\description{
Nest data.tables by group

Supports enhanced selection
}
\examples{
test_df <- data.table::data.table(a = 1:10,
  b = 11:20,
  c = c(rep("a", 6), rep("b", 4)),
  d = c(rep("a", 4), rep("b", 6)))

test_df \%>\%
  dt_group_nest()

test_df \%>\%
  dt_group_nest(c, d)

test_df \%>\%
  dt_group_nest(is.character)
}
