% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case.R
\name{dt_case}
\alias{dt_case}
\title{Case when}
\usage{
dt_case(..., default = NA)
}
\arguments{
\item{...}{Sequence of condition/value designations}

\item{default}{Default value. Set to NA. Argument must be named.}
}
\description{
This function allows you to use multiple if/else statements in one call.
Note that this function is called differently than `dplyr::case_when`! See examples
}
\examples{
library(data.table)

test_df <- data.table::data.table(
  a = 1:10,
  b = 11:20,
  c = c(rep("a", 6), rep("b", 4)),
  d = c(rep("a", 4), rep("b", 6)))

test_df \%>\%
  dt_mutate(x = dt_case(b < 13, 3,
                        a > 4, 2,
                        default = 10))
test_df \%>\%
  dt_mutate(x = dt_case(c == "a","a",
                        default = d))
}
