% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_stats.R
\name{write_stats}
\alias{write_stats}
\title{Save the results in a tidy stats list to a .csv file}
\usage{
write_stats(results, path)
}
\arguments{
\item{results}{A tidy stats list.}

\item{path}{Path or connection to write to.}
}
\description{
\code{write_stats} converts a tidy stats results list to a data frame and then saves the data to a .csv file.
}
\details{
The \code{prettyNum} function is used to format the numbers before saving them to disk. This is to prevent saving numbers with many decimals.
}
\examples{
# Create an empty list to store the results in
results <- list()

# Conduct statistical tests
model <- t.test(extra ~ group, data = sleep, paired = TRUE)

# Add output to the results list
results <- add_stats(model, results, identifier = "M1")

# Save the results
dir <- tempdir()
write_stats(results, file.path(dir, "results.txt"))

}
