% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_invalid_letters.R
\name{find_invalid_letters}
\alias{find_invalid_letters}
\alias{find_invalid_letters.sq}
\title{Find elements which are not suitable for specified type.}
\usage{
find_invalid_letters(x, dest_type, ...)

\method{find_invalid_letters}{sq}(
  x,
  dest_type,
  ...,
  NA_letter = getOption("tidysq_NA_letter")
)
}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}

\item{dest_type}{[\code{character(1)}]\cr
The name of destination type - one of \code{"dna_bsc"}, \code{"dna_ext"},
\code{"rna_bsc"}, \code{"rna_ext"}, \code{"ami_bsc"} and \code{"ami_ext"}.}

\item{...}{further arguments to be passed from or to other methods.}

\item{NA_letter}{[\code{character(1)}]\cr
A string that is used to interpret and display \code{NA} value in the
context of \code{\link[=sq-class]{sq class}}. Default value equals to
"\code{!}".}
}
\value{
A list of mismatched elements for every sequence from
\code{\link[=sq-class]{sq}} object.
}
\description{
Finds elements in given sequence not contained in amino acid or
nucleotide alphabet.
}
\details{
Amino acid, DNA and RNA standard alphabets have predefined letters. This
function allows the user to check which letters from input sequences are not
contained in selected one of these alphabets.

Returned list contains a character vector for each input sequence. Each
element of a vector is a letter that appear in corresponding sequence and not
in the target alphabet.

You can check which letters are valid for specified type in
\code{\link{alphabet}} documentation.
}
\examples{
# Creating objects to work on:
sq_unt <- sq(c("ACGPOIUATTAGACG","GGATFGHA"), alphabet = "unt")
sq_ami <- sq(c("QWERTYUIZXCVBNM","LKJHGFDSAZXCVBN"), alphabet = "ami_ext")

# Mismatched elements might be from basic type:
find_invalid_letters(sq_ami, "ami_bsc")

# But also from type completely unrelated to the current one:
find_invalid_letters(sq_unt, "dna_ext")

}
\seealso{
\code{\link{alphabet}()}

Functions that manipulate type of sequences:
\code{\link{is.sq}()},
\code{\link{sq_type}()},
\code{\link{substitute_letters}()},
\code{\link{typify}()}
}
\concept{type_functions}
