% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather.R
\name{gather}
\alias{gather}
\title{Gather columns into key-value pairs.}
\usage{
gather(data, key, value, ..., na.rm = FALSE, convert = FALSE,
  factor_key = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{key, value}{Names of key and value columns to create in output.}

\item{...}{Specification of columns to gather. Use bare variable names.
Select all variables between x and z with \code{x:z}, exclude y with
\code{-y}. For more options, see the \link[dplyr]{select} documentation.}

\item{na.rm}{If \code{TRUE}, will remove rows from output where the
value column in \code{NA}.}

\item{convert}{If \code{TRUE} will automatically run
\code{\link{type.convert}} on the key column. This is useful if the column
names are actually numeric, integer, or logical.}

\item{factor_key}{If \code{FALSE}, the default, the key values will be
stored as a character vector. If \code{TRUE}, will be stored as a factor,
which preserves the original ordering of the columns.}
}
\description{
Gather takes multiple columns and collapses into key-value pairs,
duplicating all other columns as needed. You use \code{gather()} when
you notice that you have columns that are not variables.
}
\examples{
library(dplyr)
# From http://stackoverflow.com/questions/1181060
stocks <- data_frame(
  time = as.Date('2009-01-01') + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4)
)

gather(stocks, stock, price, -time)
stocks \%>\% gather(stock, price, -time)

# get first observation for each Species in iris data -- base R
mini_iris <- iris[c(1, 51, 101), ]
# gather Sepal.Length, Sepal.Width, Petal.Length, Petal.Width
gather(mini_iris, key = flower_att, value = measurement,
       Sepal.Length, Sepal.Width, Petal.Length, Petal.Width)
# same result but less verbose
gather(mini_iris, key = flower_att, value = measurement, -Species)

# repeat iris example using dplyr and the pipe operator
library(dplyr)
mini_iris <-
  iris \%>\%
  group_by(Species) \%>\%
  slice(1)
mini_iris \%>\% gather(key = flower_att, value = measurement, -Species)
}
\seealso{
\code{\link{gather_}} for a version that uses regular evaluation
  and is suitable for programming with.
}
