% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tq_get.R
\name{tq_get}
\alias{tq_get}
\alias{tq_get_options}
\title{Get quantitative data in \code{tibble} format}
\usage{
tq_get(x, get = "stock.prices", complete_cases = TRUE, ...)

tq_get_options()
}
\arguments{
\item{x}{A single character string, a character vector or tibble representing a single (or multiple)
stock symbol, metal symbol, currency combination, FRED code, etc.}

\item{get}{A character string representing the type of data to get
for \code{x}. Options include:
\itemize{
\item \code{"stock.prices"}: Get the open, high, low, close, volume and adjusted
stock prices for a stock symbol from
Yahoo Finance (https://finance.yahoo.com/). Wrapper for \code{quantmod::getSymbols()}.
\item \code{"dividends"}: Get the dividends for a stock symbol from
Yahoo Finance (https://finance.yahoo.com/). Wrapper for \code{quantmod::getDividends()}.
\item \code{"splits"}: Get the split ratio for a stock symbol from
Yahoo Finance (https://finance.yahoo.com/). Wrapper for \code{quantmod::getSplits()}.
\item \code{"stock.prices.japan"}: Get the open, high, low, close, volume and adjusted
stock prices for a stock symbol from
Yahoo Finance Japan. Wrapper for \code{quantmod::getSymbols.yahooj()}.
\item \code{"economic.data"}: Get economic data from
\href{https://fred.stlouisfed.org/}{FRED}. rapper for \code{quantmod::getSymbols.FRED()}.
\item \code{"quandl"}: Get data sets from
\href{https://data.nasdaq.com/}{Quandl}. Wrapper for \code{Quandl::Quandl()}.
See also \code{\link[=quandl_api_key]{quandl_api_key()}}.
\item \code{"quandl.datatable"}: Get data tables from
\href{https://data.nasdaq.com/}{Quandl}. Wrapper for \code{Quandl::Quandl.datatable()}.
See also \code{\link[=quandl_api_key]{quandl_api_key()}}.
\item \code{"tiingo"}: Get data sets from
\href{https://www.tiingo.com/}{Tiingo}. Wrapper for \code{riingo::riingo_prices()}.
See also \code{\link[=tiingo_api_key]{tiingo_api_key()}}.
\item \code{"tiingo.iex"}: Get data sets from
\href{https://www.tiingo.com/}{Tiingo}. Wrapper for \code{riingo::riingo_iex_prices()}.
See also \code{\link[=tiingo_api_key]{tiingo_api_key()}}.
\item \code{"tiingo.crypto"}: Get data sets from
\href{https://www.tiingo.com/}{Tiingo}. Wrapper for \code{riingo::riingo_crypto_prices()}.
See also \code{\link[=tiingo_api_key]{tiingo_api_key()}}.
\item \code{"alphavantager"}: Get data sets from
\href{https://www.alphavantage.co/}{Alpha Vantage}. Wrapper for \code{alphavantager::av_get()}.
See also \code{\link[=av_api_key]{av_api_key()}}.
\item \code{"rblpapi"}: Get data sets from
\href{https://www.bloomberg.com/professional/solution/bloomberg-terminal/}{Bloomberg}. Wrapper for \code{Rblpapi}.
See also \code{\link[Rblpapi:blpConnect]{Rblpapi::blpConnect()}} to connect to Bloomberg terminal (required).
Use the argument \code{rblpapi_fun} to set the function such as "bdh" (default), "bds", or "bdp".
}}

\item{complete_cases}{Removes symbols that return an NA value due to an error with the get
call such as sending an incorrect symbol "XYZ" to get = "stock.prices". This is useful in
scaling so user does not need to
add an extra step to remove these rows. \code{TRUE} by default, and a warning
message is generated for any rows removed.}

\item{...}{Additional parameters passed to the "wrapped"
function. Investigate underlying functions to see full list of arguments.
Common optional parameters include:
\itemize{
\item \code{from}: Standardized for time series functions in \code{quantmod}, \code{quandl}, \code{tiingo}, \code{alphavantager} packages.
A character string representing a start date in
YYYY-MM-DD format.
\item \code{to}: Standardized for time series functions in \code{quantmod}, \code{quandl}, \code{tiingo}, \code{alphavantager} packages.
A character string representing a end date in
YYYY-MM-DD format.
}}
}
\value{
Returns data in the form of a \code{tibble} object.
}
\description{
Get quantitative data in \code{tibble} format
}
\details{
\code{tq_get()} is a consolidated function that gets data from various
web sources. The function is a wrapper for several \code{quantmod}
functions, \code{Quandl} functions, and also gets data from websources unavailable
in other packages.
The results are always returned as a \code{tibble}. The advantages
are (1) only one function is needed for all data sources and (2) the function
can be seamlessly used with the tidyverse: \code{purrr}, \code{tidyr}, and
\code{dplyr} verbs.

\code{tq_get_options()} returns a list of valid \code{get} options you can
choose from.

\code{tq_get_stock_index_options()} Is deprecated and will be removed in the
next version. Please use \code{tq_index_options()} instead.
}
\examples{
# Load libraries

# Get the list of `get` options
tq_get_options()

# Get stock prices for a stock from Yahoo
aapl_stock_prices <- tq_get("AAPL")

# Get stock prices for multiple stocks
mult_stocks <- tq_get(c("META", "AMZN"),
                      get  = "stock.prices",
                      from = "2016-01-01",
                      to   = "2017-01-01")


\dontrun{

# --- Quandl ---
if (rlang::is_installed("quandl")) {
quandl_api_key('<your_api_key>')
tq_get("EIA/PET_MTTIMUS1_M", get = "quandl", from = "2010-01-01")
}


# Energy data from EIA



# --- Tiingo ---
if (rlang::is_installed("riingo")) {
tiingo_api_key('<your_api_key>')

# Tiingo Prices (Free alternative to Yahoo Finance!)
tq_get(c("AAPL", "GOOG"), get = "tiingo", from = "2010-01-01")

# Sub-daily prices from IEX ----
tq_get(c("AAPL", "GOOG"),
       get = "tiingo.iex",
       from   = "2020-01-01",
       to     = "2020-01-15",
       resample_frequency = "5min")

# Tiingo Bitcoin Prices ----
tq_get(c("btcusd", "btceur"),
       get    = "tiingo.crypto",
       from   = "2020-01-01",
       to     = "2020-01-15",
       resample_frequency = "5min")


}

# --- Alpha Vantage ---

if (rlang::is_installed("alphavantager")) {
av_api_key('<your_api_key>')

# Daily Time Series
tq_get("AAPL",
       get        = "alphavantager",
       av_fun     = "TIME_SERIES_DAILY_ADJUSTED",
       outputsize = "full")

# Intraday 15 Min Interval
tq_get("AAPL",
       get        = "alphavantage",
       av_fun     = "TIME_SERIES_INTRADAY",
       interval   = "15min",
       outputsize = "full")
# FX DAILY
tq_get("USD/EUR", get = "alphavantage", av_fun = "FX_DAILY", outputsize = "full")

# FX REAL-TIME QUOTE
tq_get("USD/EUR", get = "alphavantage", av_fun = "CURRENCY_EXCHANGE_RATE")

}
}
}
\seealso{
\itemize{
\item \code{\link[=tq_index]{tq_index()}} to get a ful list of stocks in an index.
\item \code{\link[=tq_exchange]{tq_exchange()}} to get a ful list of stocks in an exchange.
\item \code{\link[=quandl_api_key]{quandl_api_key()}} to set the api key for collecting data via the \code{"quandl"}
get option.
\item \code{\link[=tiingo_api_key]{tiingo_api_key()}} to set the api key for collecting data via the \code{"tiingo"}
get option.
\item \code{\link[=av_api_key]{av_api_key()}} to set the api key for collecting data via the \code{"alphavantage"}
get option.
}
}
