## ----eval=FALSE---------------------------------------------------------------
#  prompt <- "Hi there!" |>
#    prompt_wrap(
#      modify_fn = function(base_prompt) {
#        paste(base_prompt, "How are you?", sep = "\n\n")
#      }
#    )

## ----eval=FALSE---------------------------------------------------------------
#  prompt <- "Hi there!" |>
#    prompt_wrap(\(x) paste(x, "How are you?", sep = "\n\n"))

## ----eval=FALSE---------------------------------------------------------------
#  my_prompt_wrap <- function(prompt) {
#    modify_fn <- function(base_prompt) {
#      paste(base_prompt, "How are you?", sep = "\n\n")
#    }
#  
#    prompt_wrap(prompt, modify_fn)
#  }
#  prompt <- "Hi there!" |>
#    my_prompt_wrap()

## ----eval=FALSE---------------------------------------------------------------
#  answer_as_boolean <- function(
#      prompt,
#      true_definition = NULL,
#      false_definition = NULL,
#      add_instruction_to_prompt = TRUE
#  ) {
#    instruction <- "You must answer with only TRUE or FALSE (use no other characters)."
#    if (!is.null(true_definition))
#      instruction <- paste(instruction, glue::glue("TRUE means: {true_definition}."))
#    if (!is.null(false_definition))
#      instruction <- paste(instruction, glue::glue("FALSE means: {false_definition}."))
#  
#    modify_fn <- function(original_prompt_text) {
#      if (!add_instruction_to_prompt) {
#        return(original_prompt_text)
#      }
#  
#      glue::glue("{original_prompt_text}\n\n{instruction}")
#    }
#  
#    extraction_fn <- function(x) {
#      normalized <- tolower(trimws(x))
#      if (normalized %in% c("true", "false")) {
#        return(as.logical(normalized))
#      }
#      return(llm_feedback(instruction))
#    }
#  
#    prompt_wrap(prompt, modify_fn, extraction_fn)
#  }

