% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-annotation.R
\name{add_annotation_text}
\alias{add_annotation_text}
\alias{add_annotation_rectangle}
\alias{add_annotation_line}
\title{Add annotation}
\usage{
add_annotation_text(plot, text, x, y, fontsize = 7)

add_annotation_rectangle(
  plot,
  xmin,
  xmax,
  ymin,
  ymax,
  fill = "#000000",
  color = NA,
  alpha = 0.1
)

add_annotation_line(plot, x, xend, y, yend, color = "#000000")
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{text}{Here goes the description.}

\item{x, xmin, xmax, xend, y, ymin, ymax, yend}{Here goes the description.}

\item{fontsize}{Font size in points. Defaults to \code{7}.}

\item{fill}{A hex color for the fill color. For example, \code{"#FFFFFF"} for white.}

\item{color}{A hex color for the stroke color. For example, \code{"#FFFFFF"} for white.}

\item{alpha}{A \code{number} between \code{0} and \code{1} for the opacity of an object. A value of \code{0} is completely transparent, \code{1} is completely opaque.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add annotation
}
\examples{
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_boxplot() |>
  add_annotation_text("Look here!", x = 2, y = 25)

eu_countries |>
  tidyplot(x = area, y = population) |>
  add_data_points() |>
  add_annotation_rectangle(xmin = 2.5e5, xmax = Inf, ymin = 42, ymax = Inf)

eu_countries |>
  tidyplot(x = area, y = population) |>
  add_data_points() |>
  add_annotation_rectangle(xmin = 2.5e5, xmax = 6e5, ymin = 42, ymax = 90,
                           color = "#E69F00", fill = NA)

eu_countries |>
  tidyplot(x = area, y = population) |>
  add_data_points() |>
  add_annotation_line(x = 0, xend = Inf, y = 0, yend = Inf)

}
